/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.net.URI;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.deployment.mavenplugin.AbstractModuleCommand;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.jmx.KernelDelegate;

public class WaitForStarted
extends AbstractModuleCommand {
    private int maxTries = 40;
    private int retryIntervalMilliseconds = 1000;
    private MBeanServerConnection mbServerConnection;
    private Kernel kernel;
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMaxTries(int maxTries) {
        this.maxTries = maxTries;
    }

    public void setRetryIntervalMilliseconds(int retryIntervalMilliseconds) {
        this.retryIntervalMilliseconds = retryIntervalMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        String uri = this.getUri().substring("deployer:geronimo:".length());
        if (!uri.startsWith("jmx")) {
            throw new Exception("bad uri");
        }
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        String[] credentials = new String[]{this.getUsername(), this.getPassword()};
        environment.put("jmx.remote.credentials", credentials);
        JMXServiceURL address = new JMXServiceURL("service:" + uri);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            int tries = this.maxTries;
            while (true) {
                try {
                    JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
                    this.mbServerConnection = jmxConnector.getMBeanServerConnection();
                    this.kernel = new KernelDelegate(this.mbServerConnection);
                }
                catch (Exception e) {
                    if (tries == 0) {
                        throw new Exception("Could not connect");
                    }
                    Thread.sleep(this.retryIntervalMilliseconds);
                    --tries;
                    continue;
                }
                break;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
        ObjectName configName = Configuration.getConfigurationObjectName((URI)new URI(this.getId()));
        for (int tries = this.maxTries; tries > 0; --tries) {
            try {
                int state = this.kernel.getGBeanState(configName);
                if (state == 1) {
                    return;
                }
            }
            catch (InternalKernelException e) {
            }
            catch (GBeanNotFoundException e) {
                // empty catch block
            }
            Thread.sleep(this.retryIntervalMilliseconds);
        }
        throw new Exception("Configuration is not yet started");
    }
}

