/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.io.File;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.system.url.GeronimoURLFactory;

public class StartServer {
    private String geronimoHome;
    private String kernelName;
    private String domainName;
    private String configs;

    public String getGeronimoHome() {
        return this.geronimoHome;
    }

    public void setGeronimoHome(String geronimoHome) {
        this.geronimoHome = geronimoHome;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public void setKernelName(String kernelName) {
        this.kernelName = kernelName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getConfigs() {
        return this.configs;
    }

    public void setConfigs(String configs) {
        this.configs = configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        System.setProperty("geronimo.base.dir", this.getGeronimoHome());
        ArrayList<URI> configList = new ArrayList<URI>();
        StringTokenizer st = new StringTokenizer(this.configs);
        while (st.hasMoreTokens()) {
            configList.add(new URI(st.nextToken()));
        }
        File root = new File(this.getGeronimoHome());
        URL systemURL = new File(root, "bin/server.jar").toURL();
        URL configURL = new URL("jar:" + systemURL.toString() + "!/META-INF/config.ser");
        GBeanData configuration = new GBeanData();
        ObjectInputStream ois = new ObjectInputStream(configURL.openStream());
        try {
            configuration.readExternal((ObjectInput)ois);
        }
        finally {
            ois.close();
        }
        URI configurationId = (URI)configuration.getAttribute("id");
        ObjectName configName = Configuration.getConfigurationObjectName((URI)configurationId);
        configuration.setName(configName);
        Kernel kernel = KernelFactory.newInstance().createKernel(this.getKernelName());
        kernel.boot();
        kernel.loadGBean(configuration, this.getClass().getClassLoader());
        kernel.setAttribute(configName, "baseURL", (Object)systemURL);
        kernel.startRecursiveGBean(configName);
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        Iterator i = configList.iterator();
        while (i.hasNext()) {
            URI configID = (URI)i.next();
            List list = configurationManager.loadRecursive(configID);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName name = (ObjectName)iterator.next();
                kernel.startRecursiveGBean(name);
                System.out.println("started gbean: " + name);
            }
        }
    }

    static {
        GeronimoLogging.initialize((GeronimoLogging)GeronimoLogging.INFO);
        GeronimoURLFactory.install();
    }
}

