/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.deployment.mavenplugin.AbstractModuleCommand;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelMBean;
import org.apache.geronimo.kernel.jmx.MBeanProxyFactory;

public class WaitForStarted
extends AbstractModuleCommand {
    private int maxTries = 20;
    private MBeanServerConnection mbServerConnection;
    private KernelMBean kernel;
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        String uri = this.getUri().substring("deployer:geronimo:".length());
        if (!uri.startsWith("jmx")) {
            throw new Exception("bad uri");
        }
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        String[] credentials = new String[]{this.getUsername(), this.getPassword()};
        environment.put("jmx.remote.credentials", credentials);
        JMXServiceURL address = new JMXServiceURL("service:" + uri);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            int tries = this.maxTries;
            while (true) {
                try {
                    JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
                    this.mbServerConnection = jmxConnector.getMBeanServerConnection();
                    this.kernel = (KernelMBean)MBeanProxyFactory.getProxy((Class)KernelMBean.class, (MBeanServerConnection)this.mbServerConnection, (ObjectName)Kernel.KERNEL);
                }
                catch (IOException e) {
                    if (tries == 0) {
                        throw new Exception("Could not connect");
                    }
                    Thread.sleep(1000L);
                    --tries;
                    continue;
                }
                break;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
        URI id = new URI(this.getId());
        for (int tries = this.maxTries; tries > 0; --tries) {
            int state = this.kernel.getConfigurationState(id);
            if (state == 1) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new Exception("Configuration is not yet started");
    }
}

