/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StartRemoteServer {
    private String geronimoTarget;
    private String vmArgs = "";
    private String configs;
    private String debugPort;
    private String output;
    private String error;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public String getGeronimoTarget() {
        return this.geronimoTarget;
    }

    public void setGeronimoTarget(String geronimoTarget) {
        this.geronimoTarget = geronimoTarget;
    }

    public String getVmArgs() {
        return this.vmArgs;
    }

    public void setVmArgs(String vmArgs) {
        this.vmArgs = vmArgs;
    }

    public String getConfigs() {
        return this.configs;
    }

    public void setConfigs(String configs) {
        this.configs = configs;
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(String debugPort) {
        this.debugPort = debugPort;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    private PrintStream getOut() {
        try {
            if (this.getOutput() != null) {
                this.out = new PrintStream(new FileOutputStream(this.getOutput()));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        return this.out;
    }

    private PrintStream getErr() {
        try {
            if (this.getError() != null) {
                this.err = new PrintStream(new FileOutputStream(this.getError()));
            } else if (this.getOutput() != null) {
                this.err = this.getOut();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        return this.err;
    }

    public void execute() throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        File root = new File(this.getGeronimoTarget());
        File systemFile = new File(root, "bin/server.jar");
        String s = File.separator;
        String java = System.getProperty("java.home") + s + "bin" + s + "java";
        cmd.add(java);
        if (this.debugPort != null) {
            cmd.add("-Xdebug");
            cmd.add("-Xnoagent");
            cmd.add("-Djava.compiler=NONE");
            cmd.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + this.debugPort);
        }
        StringTokenizer st = new StringTokenizer(this.getVmArgs());
        while (st.hasMoreTokens()) {
            cmd.add(st.nextToken());
        }
        cmd.add("-ea");
        cmd.add("-jar");
        cmd.add(systemFile.getCanonicalPath());
        st = new StringTokenizer(this.getConfigs());
        while (st.hasMoreTokens()) {
            cmd.add(st.nextToken());
        }
        String[] command = cmd.toArray(new String[0]);
        Runtime runtime = Runtime.getRuntime();
        Process server = runtime.exec(command);
        InputStream out = server.getInputStream();
        Thread serverOut = new Thread(new Pipe(out, this.getOut()));
        serverOut.setDaemon(true);
        serverOut.start();
        InputStream err = server.getErrorStream();
        Thread serverErr = new Thread(new Pipe(err, this.getErr()));
        serverErr.setDaemon(true);
        serverErr.start();
    }

    private final class Pipe
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public Pipe(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            try {
                int i;
                do {
                    i = this.in.read();
                    this.out.write(i);
                } while (i != -1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

