/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentClient {
    private static final DeploymentFactoryManager FACTORY_MANAGER = DeploymentFactoryManager.getInstance();
    private URL provider;

    public URL getProvider() {
        return this.provider;
    }

    public void setProvider(URL provider) {
        this.provider = provider;
    }

    public void doIt() throws IOException {
        DeploymentClient.registerProvider(this.provider, null);
    }

    public static void registerProvider(URL provider, ClassLoader parent) throws IOException {
        URL url;
        JarURLConnection jarConnection;
        Attributes attrs;
        String factoryNames;
        if (parent == null) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        if (parent == null) {
            parent = DeploymentClient.class.getClassLoader();
        }
        if ((factoryNames = (attrs = (jarConnection = (JarURLConnection)(url = new URL("jar:" + provider.toString() + "!/")).openConnection()).getMainAttributes()).getValue("J2EE-DeploymentFactory-Implementation-Class")) == null) {
            throw new IOException("No DeploymentFactory found in jar");
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{provider}, parent);
        StringTokenizer tokenizer = new StringTokenizer(factoryNames);
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                DeploymentFactory factory = (DeploymentFactory)cl.loadClass(className).newInstance();
                FACTORY_MANAGER.registerDeploymentFactory(factory);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to instantiate DeploymentFactory: " + className).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(final ProgressObject progress) throws InterruptedException {
        ProgressListener listener = new ProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleProgressEvent(ProgressEvent event) {
                DeploymentStatus status = event.getDeploymentStatus();
                if (status.getMessage() != null) {
                    System.out.println(status.getMessage());
                }
                if (!status.isRunning()) {
                    ProgressObject progressObject = progress;
                    synchronized (progressObject) {
                        progress.notify();
                    }
                }
            }
        };
        progress.addProgressListener(listener);
        ProgressObject progressObject = progress;
        synchronized (progressObject) {
            while (progress.getDeploymentStatus().isRunning()) {
                progress.wait();
            }
        }
    }
}

