/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.geronimo.common.DeploymentException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeployUtils {
    public static String reformat(String source, int indent, int endCol) {
        if (endCol - indent < 10) {
            throw new IllegalArgumentException("This is ridiculous!");
        }
        StringBuffer buf = new StringBuffer((int)((double)source.length() * 1.1));
        String prefix = indent == 0 ? "" : DeployUtils.buildIndent(indent);
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(source));
            block2: while ((line = in.readLine()) != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                while (line.length() > 0) {
                    line = prefix + line;
                    if (line.length() > endCol) {
                        int pos = line.lastIndexOf(32, endCol);
                        if (pos < indent && (pos = line.indexOf(32, endCol)) < indent) {
                            pos = line.length();
                        }
                        buf.append(line.substring(0, pos)).append('\n');
                        if (pos >= line.length() - 1) continue block2;
                        line = line.substring(pos + 1);
                        continue;
                    }
                    buf.append(line).append("\n");
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"This should be impossible");
        }
        return buf.toString();
    }

    private static String buildIndent(int indent) {
        StringBuffer buf = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static Collection identifyTargetModuleIDs(TargetModuleID[] allModules, String name) throws DeploymentException {
        LinkedList<TargetModuleID> list = new LinkedList<TargetModuleID>();
        int pos = name.indexOf(124);
        if (pos > -1) {
            String target = name.substring(0, pos);
            String module = name.substring(pos + 1);
            for (int i = 0; i < allModules.length; ++i) {
                if (!allModules[i].getTarget().getName().equals(target) || !allModules[i].getModuleID().equals(module)) continue;
                list.add(allModules[i]);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        for (int i = 0; i < allModules.length; ++i) {
            if (!allModules[i].getModuleID().equals(name)) continue;
            list.add(allModules[i]);
        }
        if (list.isEmpty()) {
            throw new DeploymentException(name + " does not appear to be a the name of a module " + "available on the selected server. Perhaps it has already been " + "stopped or undeployed?  If you're trying to specify a " + "TargetModuleID, use the syntax TargetName|ModuleName instead. " + "If you're not sure what's running, try the list-modules command.");
        }
        return list;
    }

    public static boolean isJarFile(File file) throws DeploymentException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new DeploymentException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int test = in.readInt();
            in.close();
            return test == 1347093252;
        }
        catch (IOException e) {
            throw new DeploymentException("Cannot read from file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractModuleIdFromArchive(File module) throws IOException, DeploymentException {
        if (!module.canRead()) {
            throw new DeploymentException("Not a readable file (" + module.getAbsolutePath() + ")");
        }
        if (module.isDirectory()) {
            File target = null;
            if (new File(module, "WEB-INF/web.xml").canRead()) {
                target = new File(module, "WEB-INF/geronimo-web.xml");
            } else if (new File(module, "META-INF/application.xml").canRead()) {
                target = new File(module, "META-INF/geronimo-application.xml");
            } else if (new File(module, "META-INF/ejb-jar.xml").canRead()) {
                target = new File(module, "META-INF/openejb-jar.xml");
            } else if (new File(module, "META-INF/ra.xml").canRead()) {
                target = new File(module, "META-INF/geronimo-ra.xml");
            } else if (new File(module, "META-INF/application-client.xml").canRead()) {
                target = new File(module, "META-INF/geronimo-application-client.xml");
            }
            if (target != null && target.canRead()) {
                BufferedReader in = new BufferedReader(new FileReader(target));
                return DeployUtils.extractModuleIdFromPlan(in);
            }
        } else {
            if (!DeployUtils.isJarFile(module)) {
                throw new DeploymentException(module.getAbsolutePath() + " is neither a JAR file nor a directory!");
            }
            JarFile input = new JarFile(module);
            try {
                JarEntry entry = null;
                if (input.getJarEntry("WEB-INF/web.xml") != null) {
                    entry = input.getJarEntry("WEB-INF/geronimo-web.xml");
                } else if (input.getJarEntry("META-INF/application.xml") != null) {
                    entry = input.getJarEntry("META-INF/geronimo-application.xml");
                } else if (input.getJarEntry("META-INF/ejb-jar.xml") != null) {
                    entry = input.getJarEntry("META-INF/openejb-jar.xml");
                } else if (input.getJarEntry("META-INF/ra.xml") != null) {
                    entry = input.getJarEntry("META-INF/geronimo-ra.xml");
                } else if (input.getJarEntry("META-INF/application-client.xml") != null) {
                    entry = input.getJarEntry("META-INF/geronimo-application-client.xml");
                }
                if (entry != null) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(input.getInputStream(entry)));
                    String string = DeployUtils.extractModuleIdFromPlan(in);
                    return string;
                }
            }
            finally {
                input.close();
            }
        }
        return null;
    }

    public static String extractModuleIdFromPlan(File plan) throws IOException {
        if (plan.isDirectory() || !plan.canRead()) {
            throw new IllegalArgumentException(plan.getAbsolutePath() + " is not a readable XML file!");
        }
        BufferedReader in = new BufferedReader(new FileReader(plan));
        return DeployUtils.extractModuleIdFromPlan(in);
    }

    private static String extractModuleIdFromPlan(Reader plan) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            SAXParser parser = factory.newSAXParser();
            ConfigIdHandler handler = new ConfigIdHandler();
            parser.parse(new InputSource(plan), (DefaultHandler)handler);
            String string = handler.configId;
            return string;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to read plan: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("Unable to read plan: " + e.getMessage());
        }
        finally {
            plan.close();
        }
    }

    private static class ConfigIdHandler
    extends DefaultHandler {
        private String configId;

        private ConfigIdHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.configId == null) {
                this.configId = attributes.getValue("configId");
            }
        }
    }
}

