/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandListModules
extends AbstractCommand {
    public CommandListModules() {
        super("list-modules", "2. Other Commands", "[--all|--started|--stopped] [target*]", "Lists the modules available on the specified targets.  If --started or --stopped is specified, only started or stopped modules will be listed; otherwise all modules will be listed.  If no targets are specified, then modules on all targets will be listed; otherwise only modules on the specified targets.");
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        TargetModuleID child;
        int j;
        TargetModuleID result;
        int i;
        if (!connection.isOnline()) {
            throw new DeploymentException("This command cannot be run unless connecting to a running server.  Specify --url if server is not running on the default port on localhost.");
        }
        ArrayList<String> targets = new ArrayList<String>();
        Boolean started = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (arg.startsWith("--")) {
                if (arg.equals("--all")) {
                    if (started == null) continue;
                    throw new DeploymentSyntaxException("Cannot specify more than one of --all, --started, --stopped");
                }
                if (arg.equals("--started")) {
                    if (started != null) {
                        throw new DeploymentSyntaxException("Cannot specify more than one of --all, --started, --stopped");
                    }
                    started = Boolean.TRUE;
                    continue;
                }
                if (arg.equals("--stopped")) {
                    if (started != null) {
                        throw new DeploymentSyntaxException("Cannot specify more than one of --all, --started, --stopped");
                    }
                    started = Boolean.FALSE;
                    continue;
                }
                throw new DeploymentSyntaxException("Unrecognized option '" + arg + "'");
            }
            targets.add(arg);
        }
        DeploymentManager mgr = connection.getDeploymentManager();
        TargetModuleID[] running = null;
        TargetModuleID[] notrunning = null;
        Target[] tlist = CommandListModules.identifyTargets(targets, mgr);
        if (tlist.length == 0) {
            tlist = mgr.getTargets();
        }
        try {
            if (started == null || started.booleanValue()) {
                running = mgr.getRunningModules(null, tlist);
            }
            if (started == null || !started.booleanValue()) {
                notrunning = mgr.getNonRunningModules(null, tlist);
            }
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to query modules", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new DeploymentSyntaxException(e.getMessage());
        }
        if (running == null) {
            running = new TargetModuleID[]{};
        }
        if (notrunning == null) {
            notrunning = new TargetModuleID[]{};
        }
        int total = running.length + notrunning.length;
        out.println("Found " + total + " module" + (total != 1 ? "s" : ""));
        for (i = 0; i < running.length; ++i) {
            result = running[i];
            out.println("  + " + result.getModuleID() + (tlist.length > 1 ? " on " + result.getTarget().getName() : "") + (result.getWebURL() == null ? "" : " @ " + result.getWebURL()));
            if (result.getChildTargetModuleID() == null) continue;
            for (j = 0; j < result.getChildTargetModuleID().length; ++j) {
                child = result.getChildTargetModuleID()[j];
                out.println("      `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL()));
            }
        }
        for (i = 0; i < notrunning.length; ++i) {
            result = notrunning[i];
            out.println("    " + result.getModuleID() + (tlist.length > 1 ? " on " + result.getTarget().getName() : ""));
            if (result.getChildTargetModuleID() == null) continue;
            for (j = 0; j < result.getChildTargetModuleID().length; ++j) {
                child = result.getChildTargetModuleID()[j];
                out.println("      `-> " + child.getModuleID());
            }
        }
    }
}

