/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandStart
extends AbstractCommand {
    public CommandStart() {
        super("start", "1. Common Commands", "[ModuleID|TargetModuleID]+", "Accepts the configId of a module, or the fully-qualified TargetModuleID identifying both the module and the server or cluster it's on, and starts that module.  The module should be available to the server but not currently running.  If multiple modules are specified, they will all be started.\nIf the server is not running, the module will be marked to start next time the server is started.");
    }

    public CommandStart(String command, String group, String helpArgumentList, String helpText) {
        super(command, group, helpArgumentList, helpText);
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        if (!connection.isOnline()) {
            throw new DeploymentException("This command cannot be run unless connecting to a running server.  Specify --url if server is not running on the default port on localhost.");
        }
        if (args.length == 0) {
            throw new DeploymentSyntaxException("Must specify at least one module name or TargetModuleID");
        }
        DeploymentManager mgr = connection.getDeploymentManager();
        Target[] allTargets = mgr.getTargets();
        TargetModuleID[] allModules = new TargetModuleID[]{};
        try {
            allModules = mgr.getAvailableModules(null, allTargets);
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to load module list from server", (Throwable)e);
        }
        ArrayList modules = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            modules.addAll(CommandStart.identifyTargetModuleIDs(allModules, args[i]));
        }
        TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
        boolean multiple = CommandStart.isMultipleTargets(ids);
        ProgressObject po = this.runCommand(out, mgr, ids);
        TargetModuleID[] done = po.getResultTargetModuleIDs();
        for (int i = 0; i < done.length; ++i) {
            TargetModuleID id = done[i];
            out.println(DeployUtils.reformat(this.getAction() + " " + id.getModuleID() + (multiple ? " on " + id.getTarget().getName() : ""), 4, 72));
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }

    protected ProgressObject runCommand(PrintWriter out, DeploymentManager mgr, TargetModuleID[] ids) {
        ProgressObject po = mgr.start(ids);
        CommandStart.waitForProgress(out, po);
        return po;
    }

    protected String getAction() {
        return "Started";
    }
}

