/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandPackage
extends AbstractCommand {
    public CommandPackage() {
        super("package", "3. Use if you know what you're doing", "[--classPath path] [--mainClass class] [--install] [module] [plan] fileName", "Creates a configuration JAR rather than installing into the server environment.  The fileName argument specifies the JAR to create.  The optional classPath argument specifies a Class-Path to include in the JAR manifest.  The optional mainClass argument specifies the Main-Class to include in the JAR manifest.  The install option specifies that the configuration should be build into a JAR and also installed into the server configuration (otherwise it is packaged but not installed).\nThe standard arguments may not be used with this command -- it never connects to a remote server.");
    }

    public boolean isLocalOnly() {
        return true;
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] argArray) throws DeploymentException {
        File test;
        String arg;
        if (connection.isOnline()) {
            throw new DeploymentException("This command cannot be run when the server is running.  Make sure the server is shut down first.");
        }
        String classPath = null;
        String mainClass = null;
        String endorsedDirs = null;
        boolean install = false;
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argArray));
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            arg = (String)iterator.next();
            if (arg.equals("--classPath")) {
                iterator.remove();
                classPath = (String)iterator.next();
                iterator.remove();
                continue;
            }
            if (arg.equals("--mainClass")) {
                iterator.remove();
                mainClass = (String)iterator.next();
                iterator.remove();
                continue;
            }
            if (arg.equals("--endorsedDirs")) {
                iterator.remove();
                endorsedDirs = (String)iterator.next();
                iterator.remove();
                continue;
            }
            if (arg.equals("--install")) {
                iterator.remove();
                install = true;
                continue;
            }
            if (!arg.startsWith("--")) break;
            throw new DeploymentSyntaxException("Invalid option '" + arg + "'");
        }
        iterator = args.iterator();
        while (iterator.hasNext()) {
            arg = (String)iterator.next();
            if (!arg.startsWith("--")) continue;
            throw new DeploymentSyntaxException("All command line options must appear before module, plan or packageFile: " + arg);
        }
        if (args.isEmpty()) {
            throw new DeploymentSyntaxException("No fileName specified for package command");
        }
        File packageFile = new File(args.removeLast());
        File parent = packageFile.getAbsoluteFile().getParentFile();
        if (!parent.exists() || !parent.canWrite()) {
            throw new DeploymentSyntaxException("Cannot write to output file " + packageFile.getAbsolutePath());
        }
        File module = null;
        File plan = null;
        if (!args.isEmpty()) {
            test = new File(args.removeLast()).getAbsoluteFile();
            if (DeployUtils.isJarFile(test) || test.isDirectory()) {
                module = test;
            } else {
                plan = test;
            }
        }
        if (!args.isEmpty()) {
            test = new File(args.removeLast()).getAbsoluteFile();
            if (DeployUtils.isJarFile(test) || test.isDirectory()) {
                if (module != null) {
                    throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                }
                module = test;
            } else {
                if (plan != null) {
                    throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                }
                plan = test;
            }
        }
        if (!args.isEmpty()) {
            throw new DeploymentSyntaxException("Too many arguments for package command");
        }
        List list = (List)connection.invokeOfflineDeployer(new Object[]{plan, module, packageFile, install ? Boolean.TRUE : Boolean.FALSE, mainClass, classPath, endorsedDirs}, new String[]{File.class.getName(), File.class.getName(), File.class.getName(), Boolean.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
        for (int j = 0; j < list.size(); ++j) {
            out.println("Packaged configuration " + list.get(j) + " to " + packageFile);
        }
    }
}

