/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.PrintWriter;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.CommandDistribute;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandDeploy
extends CommandDistribute {
    public CommandDeploy() {
        super("deploy", "1. Common Commands", "[--targets target;target;...] [module] [plan]", "Normally both a module and plan are passed to the deployer.  Sometimes the module contains a plan, or requires no plan, in which case the plan may be omitted.  Sometimes the plan references a module already deployed in the Geronimo server environment, in which case a module does not need to be provided.\nIf the server is not currently running, the module will be marked to start next time the server is started.\nIf no targets are provided, the module is deployed to all available targets.  Geronimo only provides one target (ever), so this is primarily useful when using a different driver.");
    }

    protected String getAction() {
        return "Deployed";
    }

    protected ProgressObject runCommand(DeploymentManager mgr, PrintWriter out, Target[] tlist, File module, File plan) throws DeploymentException {
        ProgressObject po = mgr.distribute(tlist, module, plan);
        CommandDeploy.waitForProgress(out, po);
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Unable to distribute " + (module == null ? plan.getName() : module.getName()) + ": " + po.getDeploymentStatus().getMessage());
        }
        return mgr.start(po.getResultTargetModuleIDs());
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        if (!connection.isOnline()) {
            throw new DeploymentException("This command cannot be run unless connecting to a running server.  Specify --url if server is not running on the default port on localhost.");
        }
        super.execute(out, connection, args);
    }
}

