/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;

public abstract class AbstractCommand
implements DeployCommand {
    private String command;
    private String group;
    private String helpArgumentList;
    private String helpText;

    public AbstractCommand(String command, String group, String helpArgumentList, String helpText) {
        this.command = command;
        this.group = group;
        this.helpArgumentList = helpArgumentList;
        this.helpText = helpText;
    }

    public String getCommandName() {
        return this.command;
    }

    public String getHelpArgumentList() {
        return this.helpArgumentList;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String getCommandGroup() {
        return this.group;
    }

    public boolean isLocalOnly() {
        return false;
    }

    protected static void waitForProgress(PrintWriter out, ProgressObject po) {
        po.addProgressListener(new ProgressListener(){
            String last = null;

            public void handleProgressEvent(ProgressEvent event) {
                String msg = event.getDeploymentStatus().getMessage();
                if (this.last != null && !this.last.equals(msg)) {
                    System.out.println(DeployUtils.reformat(this.last, 8, 72));
                }
                this.last = msg;
            }
        });
        while (po.getDeploymentStatus().isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(out);
            }
        }
    }

    protected static boolean isMultipleTargets(TargetModuleID[] ids) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            TargetModuleID id = ids[i];
            set.add(id.getTarget().getName());
        }
        return set.size() > 1;
    }

    protected static Target[] identifyTargets(List targetNames, DeploymentManager mgr) throws DeploymentException {
        Target[] tlist = new Target[targetNames.size()];
        Target[] all = mgr.getTargets();
        HashSet<String> found = new HashSet<String>();
        for (int i = 0; i < tlist.length; ++i) {
            if (found.contains(targetNames.get(i))) {
                throw new DeploymentException("Target list should not contain duplicates (" + targetNames.get(i) + ")");
            }
            for (int j = 0; j < all.length; ++j) {
                Target server = all[j];
                if (!server.getName().equals(targetNames.get(i))) continue;
                tlist[i] = server;
                found.add(server.getName());
                break;
            }
            if (tlist[i] != null) continue;
            throw new DeploymentException("No target named '" + targetNames.get(i) + "' was found");
        }
        return tlist;
    }

    protected static Collection identifyTargetModuleIDs(TargetModuleID[] allModules, String name) throws DeploymentException {
        LinkedList<TargetModuleID> list = new LinkedList<TargetModuleID>();
        int pos = name.indexOf(124);
        if (pos > -1) {
            String target = name.substring(0, pos);
            String module = name.substring(pos + 1);
            for (int i = 0; i < allModules.length; ++i) {
                if (!allModules[i].getTarget().getName().equals(target) || !allModules[i].getModuleID().equals(module)) continue;
                list.add(allModules[i]);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        for (int i = 0; i < allModules.length; ++i) {
            if (!allModules[i].getModuleID().equals(name)) continue;
            list.add(allModules[i]);
        }
        if (list.isEmpty()) {
            throw new DeploymentException(name + " does not appear to be a TargetModuleID or the name of a module available on the selected server.  For a TargetModuleID, specify it as TargetName|ModuleName");
        }
        return list;
    }
}

