/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.deployment.plugin.local.DistributeCommand;
import org.apache.geronimo.deployment.plugin.local.RedeployCommand;
import org.apache.geronimo.deployment.plugin.remote.RemoteDeployUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.jmx.KernelDelegate;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginList;
import org.apache.geronimo.system.plugin.PluginMetadata;
import org.apache.geronimo.system.plugin.PluginRepositoryList;

public class RemoteDeploymentManager
extends JMXDeploymentManager
implements GeronimoDeploymentManager {
    private JMXConnector jmxConnector;
    private boolean isSameMachine;

    public RemoteDeploymentManager(JMXConnector jmxConnector, String hostname) throws IOException {
        this.jmxConnector = jmxConnector;
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        this.initialize((Kernel)new KernelDelegate(mbServerConnection));
        this.checkSameMachine(hostname);
    }

    public boolean isSameMachine() {
        return this.isSameMachine;
    }

    private void checkSameMachine(String hostname) {
        this.isSameMachine = false;
        if (hostname.equals("localhost") || hostname.equals("127.0.0.1")) {
            this.isSameMachine = true;
            return;
        }
        try {
            InetAddress dest = InetAddress.getByName(hostname);
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                Enumeration<InetAddress> ine = iface.getInetAddresses();
                while (ine.hasMoreElements()) {
                    InetAddress address = ine.nextElement();
                    if (!address.equals(dest)) continue;
                    this.isSameMachine = true;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unable to look up host name '" + hostname + "'; assuming it is a different machine, but this may not get very far.  (" + e.getMessage() + ")");
        }
    }

    public void release() {
        super.release();
        try {
            this.jmxConnector.close();
            this.jmxConnector = null;
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException("Unable to close connection").initCause(e);
        }
    }

    protected DistributeCommand createDistributeCommand(Target[] targetList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    protected DistributeCommand createDistributeCommand(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    protected RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    protected RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    public PluginList listPlugins(URL mavenRepository, String username, String password) throws FailedLoginException, IOException {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            PluginList results = installer.listPlugins(mavenRepository, username, password);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return results;
        }
        return null;
    }

    public DownloadResults install(PluginList installList, String username, String password) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            DownloadResults results = installer.install(installList, username, password);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return results;
        }
        return null;
    }

    public void install(PluginList configsToInstall, String username, String password, DownloadPoller poller) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            installer.install(configsToInstall, username, password, poller);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return;
        }
    }

    public Object startInstall(PluginList configsToInstall, String username, String password) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            Object result = installer.startInstall(configsToInstall, username, password);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return result;
        }
        return null;
    }

    public Object startInstall(File carFile, String username, String password) {
        Set set;
        Iterator it;
        File[] args = new File[]{carFile};
        if (!this.isSameMachine) {
            AbstractDeployCommand progress = new AbstractDeployCommand(CommandType.DISTRIBUTE, this.kernel, null, null, null, null, false){

                public void run() {
                }
            };
            progress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    System.out.println(event.getDeploymentStatus().getMessage());
                }
            });
            RemoteDeployUtil.uploadFilesToServer(args, progress);
        }
        if ((it = (set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()))).iterator()).hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            Object result = installer.startInstall(carFile, username, password);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return result;
        }
        return null;
    }

    public DownloadResults checkOnInstall(Object key) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            DownloadResults result = installer.checkOnInstall(key);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return result;
        }
        return null;
    }

    public Map getInstalledPlugins() {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            Map result = installer.getInstalledPlugins();
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return result;
        }
        return null;
    }

    public PluginMetadata getPluginMetadata(Artifact configId) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            PluginMetadata result = installer.getPluginMetadata(configId);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return result;
        }
        return null;
    }

    public void updatePluginMetadata(PluginMetadata metadata) {
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator it = set.iterator();
        if (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginInstaller installer = (PluginInstaller)this.kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            installer.updatePluginMetadata(metadata);
            this.kernel.getProxyManager().destroyProxy((Object)installer);
            return;
        }
    }

    public URL[] getRepositories() {
        ArrayList<URL> list = new ArrayList<URL>();
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginRepositoryList.class.getName()));
        Iterator it = set.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            PluginRepositoryList repo = (PluginRepositoryList)this.kernel.getProxyManager().createProxy(name, class$org$apache$geronimo$system$plugin$PluginRepositoryList == null ? RemoteDeploymentManager.class$("org.apache.geronimo.system.plugin.PluginRepositoryList") : class$org$apache$geronimo$system$plugin$PluginRepositoryList);
            list.addAll(Arrays.asList(repo.getRepositories()));
            this.kernel.getProxyManager().destroyProxy((Object)repo);
        }
        return list.toArray(new URL[list.size()]);
    }
}

