/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.net.URI;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;

public class UndeployCommand
extends CommandSupport {
    private static final String[] UNINSTALL_SIG = new String[]{URI.class.getName()};
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public UndeployCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.UNDEPLOY);
        this.kernel = kernel;
        this.modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleIDImpl module = (TargetModuleIDImpl)this.modules[i];
                    Artifact moduleID = Artifact.create((String)module.getModuleID());
                    try {
                        configurationManager.stopConfiguration(moduleID);
                        configurationManager.unloadConfiguration(moduleID);
                        this.updateStatus("Module " + moduleID + " unloaded.");
                    }
                    catch (InternalKernelException e) {
                    }
                    catch (NoSuchConfigException e) {
                        // empty catch block
                    }
                    try {
                        configurationManager.uninstallConfiguration(moduleID);
                        this.updateStatus("Module " + moduleID + " uninstalled.");
                        this.addModule(module);
                        continue;
                    }
                    catch (NoSuchConfigException e) {
                        // empty catch block
                    }
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            if (this.getModuleCount() < this.modules.length) {
                this.updateStatus("Some of the modules to undeploy were not previously deployed.  This is not treated as an error.");
            }
            this.complete("Completed");
        }
        catch (Exception e) {
            this.doFail(e);
        }
    }
}

