/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;

public class StopCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StopCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.STOP);
        this.kernel = kernel;
        this.modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleID module = this.modules[i];
                    Artifact moduleID = Artifact.create((String)module.getModuleID());
                    if (configurationManager.isRunning(moduleID)) {
                        configurationManager.stopConfiguration(moduleID);
                    }
                    if (!configurationManager.isLoaded(moduleID)) continue;
                    configurationManager.unloadConfiguration(moduleID);
                    this.addModule(module);
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            if (this.getModuleCount() < this.modules.length) {
                this.fail("Some modules could not be stopped");
            } else {
                this.complete("Completed");
            }
        }
        catch (Exception e) {
            this.doFail(e);
        }
    }
}

