/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.net.URI;
import java.util.List;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;

public class StartCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StartCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.START);
        this.kernel = kernel;
        this.modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleID module = this.modules[i];
                    URI moduleID = URI.create(module.getModuleID());
                    try {
                        if (this.kernel.getGBeanState(Configuration.getConfigurationObjectName((URI)moduleID)) == 1) {
                            this.updateStatus("Module " + moduleID + " is already running");
                            Thread.sleep(100L);
                            continue;
                        }
                    }
                    catch (GBeanNotFoundException e) {
                        // empty catch block
                    }
                    List list = configurationManager.loadRecursive(moduleID);
                    for (int j = 0; j < list.size(); ++j) {
                        URI name = (URI)list.get(j);
                        configurationManager.loadGBeans(name);
                        configurationManager.start(name);
                        String configName = name.toString();
                        List kids = StartCommand.loadChildren(this.kernel, configName);
                        TargetModuleIDImpl id = new TargetModuleIDImpl(this.modules[i].getTarget(), configName, kids.toArray(new String[kids.size()]));
                        if (StartCommand.isWebApp(this.kernel, configName)) {
                            id.setType(ModuleType.WAR);
                        }
                        if (id.getChildTargetModuleID() != null) {
                            for (int k = 0; k < id.getChildTargetModuleID().length; ++k) {
                                TargetModuleIDImpl child = (TargetModuleIDImpl)id.getChildTargetModuleID()[k];
                                if (!StartCommand.isWebApp(this.kernel, child.getModuleID())) continue;
                                child.setType(ModuleType.WAR);
                            }
                        }
                        this.addModule(id);
                    }
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            this.addWebURLs(this.kernel);
            this.complete("Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.doFail(e);
        }
    }
}

