/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.plugin.local.DistributeCommand;
import org.apache.geronimo.deployment.plugin.remote.RedeployCommand;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.KernelDelegate;

public class RemoteDeploymentManager
extends JMXDeploymentManager {
    private JMXConnector jmxConnector;
    private boolean isSameMachine;

    public RemoteDeploymentManager(JMXConnector jmxConnector, String hostname) throws IOException {
        this.jmxConnector = jmxConnector;
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        this.initialize((Kernel)new KernelDelegate(mbServerConnection));
        this.checkSameMachine(hostname);
    }

    public boolean isSameMachine() {
        return this.isSameMachine;
    }

    private void checkSameMachine(String hostname) {
        this.isSameMachine = false;
        if (hostname.equals("localhost") || hostname.equals("127.0.0.1")) {
            this.isSameMachine = true;
            return;
        }
        try {
            InetAddress dest = InetAddress.getByName(hostname);
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                Enumeration<InetAddress> ine = iface.getInetAddresses();
                while (ine.hasMoreElements()) {
                    InetAddress address = ine.nextElement();
                    if (!address.equals(dest)) continue;
                    this.isSameMachine = true;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unable to look up host name '" + hostname + "'; assuming it is a different machine, but this may not get very far.  (" + e.getMessage() + ")");
        }
    }

    public void release() {
        super.release();
        try {
            this.jmxConnector.close();
            this.jmxConnector = null;
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException("Unable to close connection").initCause(e);
        }
    }

    protected DistributeCommand createDistributeCommand(Target[] targetList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    protected DistributeCommand createDistributeCommand(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    protected org.apache.geronimo.deployment.plugin.local.RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    protected org.apache.geronimo.deployment.plugin.local.RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }
}

