/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin;

import java.io.Serializable;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;

public class TargetModuleIDImpl
implements TargetModuleID,
Serializable {
    private String webURL;
    private ModuleType type;
    private final Target target;
    private final String moduleID;
    private final TargetModuleID parentTargetModuleID;
    private final TargetModuleID[] childTargetModuleID;

    public TargetModuleIDImpl(Target target, String moduleID) {
        this.target = target;
        this.moduleID = moduleID;
        this.parentTargetModuleID = null;
        this.childTargetModuleID = null;
    }

    public TargetModuleIDImpl(Target target, String moduleID, String[] childIDs) {
        this.target = target;
        this.moduleID = moduleID;
        this.parentTargetModuleID = null;
        if (childIDs == null || childIDs.length == 0) {
            this.childTargetModuleID = null;
        } else {
            this.childTargetModuleID = new TargetModuleID[childIDs.length];
            for (int i = 0; i < childIDs.length; ++i) {
                String childID = childIDs[i];
                this.childTargetModuleID[i] = new TargetModuleIDImpl(target, childID, this);
            }
        }
    }

    private TargetModuleIDImpl(Target target, String moduleID, TargetModuleID parent) {
        this.target = target;
        this.moduleID = moduleID;
        this.parentTargetModuleID = parent;
        this.childTargetModuleID = null;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.parentTargetModuleID;
    }

    public TargetModuleID[] getChildTargetModuleID() {
        return this.childTargetModuleID;
    }

    public String getWebURL() {
        return this.webURL;
    }

    public void setWebURL(String webURL) {
        this.webURL = webURL;
    }

    public ModuleType getType() {
        return this.type;
    }

    public void setType(ModuleType type) {
        this.type = type;
    }

    public String toString() {
        return "[" + this.target + ", " + this.moduleID + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetModuleIDImpl)) {
            return false;
        }
        TargetModuleIDImpl targetModuleID = (TargetModuleIDImpl)o;
        if (!this.moduleID.equals(targetModuleID.moduleID)) {
            return false;
        }
        return this.target.equals(targetModuleID.target);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = 29 * result + this.moduleID.hashCode();
        return result;
    }
}

