/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;

public abstract class CommandSupport
implements ProgressObject,
Runnable {
    private final CommandType command;
    private ActionType action;
    private StateType state;
    private String message;
    private final Set listeners = new HashSet();
    private final List moduleIDs = new ArrayList();
    private JMXDeploymentManager.CommandContext commandContext = new JMXDeploymentManager.CommandContext();
    private ProgressEvent event = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CommandSupport(CommandType command) {
        this.command = command;
        this.action = ActionType.EXECUTE;
        this.state = StateType.RUNNING;
        this.message = null;
    }

    protected synchronized void addModule(TargetModuleID moduleID) {
        this.moduleIDs.add(moduleID);
    }

    protected synchronized int getModuleCount() {
        return this.moduleIDs.size();
    }

    public synchronized TargetModuleID[] getResultTargetModuleIDs() {
        return this.moduleIDs.toArray(new TargetModuleID[this.moduleIDs.size()]);
    }

    public synchronized DeploymentStatus getDeploymentStatus() {
        return new Status(this.command, this.action, this.state, this.message);
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener pol) {
        ProgressEvent event = null;
        CommandSupport commandSupport = this;
        synchronized (commandSupport) {
            this.listeners.add(pol);
            event = this.event;
        }
        if (event != null) {
            pol.handleProgressEvent(event);
        }
    }

    public synchronized void removeProgressListener(ProgressListener pol) {
        this.listeners.remove(pol);
    }

    protected final void fail(String message) {
        this.sendEvent(message, StateType.FAILED);
    }

    protected final void complete(String message) {
        this.sendEvent(message, StateType.COMPLETED);
    }

    protected final void updateStatus(String message) {
        this.sendEvent(message, this.state);
    }

    protected void doFail(Exception e) {
        Exception test;
        if (e instanceof InternalKernelException && (test = (Exception)((InternalKernelException)e).getCause()) != null) {
            e = test;
        }
        if (this.commandContext.isLogErrors()) {
            System.err.println("Deployer operation failed: " + e.getMessage());
            if (this.commandContext.isVerbose()) {
                e.printStackTrace(System.err);
            }
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println(e.getMessage());
        if (this.commandContext.isVerbose()) {
            e.printStackTrace(printWriter);
        } else {
            Throwable throwable = e;
            while (null != (throwable = throwable.getCause())) {
                printWriter.println("\t" + throwable.getMessage());
            }
        }
        this.fail(writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(String message, StateType state) {
        ProgressListener[] toNotify;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"Trying to send event whilst holding lock");
        }
        CommandSupport commandSupport = this;
        synchronized (commandSupport) {
            this.message = message;
            this.state = state;
            Status newStatus = new Status(this.command, this.action, state, message);
            toNotify = this.listeners.toArray(new ProgressListener[this.listeners.size()]);
            this.event = new ProgressEvent((Object)this, null, (DeploymentStatus)newStatus);
        }
        for (int i = 0; i < toNotify.length; ++i) {
            toNotify[i].handleProgressEvent(this.event);
        }
    }

    protected static String clean(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public JMXDeploymentManager.CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(JMXDeploymentManager.CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public static ModuleType convertModuleType(ConfigurationModuleType type) {
        if (type.getValue() == ConfigurationModuleType.WAR.getValue()) {
            return ModuleType.WAR;
        }
        if (type.getValue() == ConfigurationModuleType.RAR.getValue()) {
            return ModuleType.RAR;
        }
        if (type.getValue() == ConfigurationModuleType.EJB.getValue()) {
            return ModuleType.EJB;
        }
        if (type.getValue() == ConfigurationModuleType.EAR.getValue()) {
            return ModuleType.EAR;
        }
        if (type.getValue() == ConfigurationModuleType.CAR.getValue()) {
            return ModuleType.CAR;
        }
        return null;
    }

    public static boolean isWebApp(Kernel kernel, String configName) {
        try {
            Set set = kernel.listGBeans(new ObjectName("*:j2eeType=WebModule,name=" + configName + ",*"));
            return set.size() > 0;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void addWebURLs(Kernel kernel) {
        CommandSupport.addWebURLs(kernel, this.moduleIDs);
    }

    public static void addWebURLs(Kernel kernel, List moduleIDs) {
        Set webApps = null;
        String url = null;
        for (int i = 0; i < moduleIDs.size(); ++i) {
            TargetModuleIDImpl id = (TargetModuleIDImpl)moduleIDs.get(i);
            if (id.getType() != null && id.getType().getValue() == ModuleType.WAR.getValue()) {
                if (webApps == null) {
                    webApps = kernel.listGBeans(new GBeanQuery(null, "org.apache.geronimo.management.geronimo.WebModule"));
                    Set set = kernel.listGBeans(new GBeanQuery(null, "org.apache.geronimo.management.geronimo.WebConnector"));
                    HashMap<String, ObjectName> map = new HashMap<String, ObjectName>();
                    ObjectName connector = null;
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        ObjectName name = (ObjectName)it.next();
                        try {
                            String protocol = (String)kernel.getAttribute(name, "protocol");
                            map.put(protocol, name);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        connector = (ObjectName)map.get("HTTP");
                        if (connector == null && (connector = (ObjectName)map.get("HTTPS")) == null) {
                            connector = (ObjectName)map.get("AJP");
                        }
                        if (connector == null) continue;
                        try {
                            url = (String)kernel.getAttribute(connector, "connectUrl");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            url = null;
                        }
                    }
                }
                Iterator it = webApps.iterator();
                while (it.hasNext()) {
                    ObjectName name = (ObjectName)it.next();
                    if (!name.getKeyProperty("name").equals(id.getModuleID())) continue;
                    try {
                        id.setWebURL(url == null ? (String)kernel.getAttribute(name, "contextPath") : url + kernel.getAttribute(name, "contextPath"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (id.getChildTargetModuleID() == null) continue;
            CommandSupport.addWebURLs(kernel, Arrays.asList(id.getChildTargetModuleID()));
        }
    }

    public static List loadChildren(Kernel kernel, String configName) throws MalformedObjectNameException {
        String childName;
        ObjectName child;
        ArrayList<String> kids = new ArrayList<String>();
        Set test = kernel.listGBeans(new ObjectName("*:J2EEApplication=" + configName + ",j2eeType=WebModule,*"));
        Iterator it = test.iterator();
        while (it.hasNext()) {
            child = (ObjectName)it.next();
            childName = child.getKeyProperty("name");
            kids.add(childName);
        }
        test = kernel.listGBeans(new ObjectName("*:J2EEApplication=" + configName + ",j2eeType=EJBModule,*"));
        it = test.iterator();
        while (it.hasNext()) {
            child = (ObjectName)it.next();
            childName = child.getKeyProperty("name");
            kids.add(childName);
        }
        test = kernel.listGBeans(new ObjectName("*:J2EEApplication=" + configName + ",j2eeType=AppClientModule,*"));
        it = test.iterator();
        while (it.hasNext()) {
            child = (ObjectName)it.next();
            childName = child.getKeyProperty("name");
            kids.add(childName);
        }
        test = kernel.listGBeans(new ObjectName("*:J2EEApplication=" + configName + ",j2eeType=ResourceAdapterModule,*"));
        it = test.iterator();
        while (it.hasNext()) {
            child = (ObjectName)it.next();
            childName = child.getKeyProperty("name");
            kids.add(childName);
        }
        return kids;
    }

    static {
        $assertionsDisabled = !CommandSupport.class.desiredAssertionStatus();
    }

    private static class Status
    implements DeploymentStatus {
        private final CommandType command;
        private final ActionType action;
        private final StateType state;
        private final String message;

        public Status(CommandType command, ActionType action, StateType state, String message) {
            this.command = command;
            this.action = action;
            this.state = state;
            this.message = message;
        }

        public CommandType getCommand() {
            return this.command;
        }

        public ActionType getAction() {
            return this.action;
        }

        public String getMessage() {
            return this.message;
        }

        public StateType getState() {
            return this.state;
        }

        public boolean isRunning() {
            return StateType.RUNNING.equals(this.state);
        }

        public boolean isCompleted() {
            return StateType.COMPLETED.equals(this.state);
        }

        public boolean isFailed() {
            return StateType.FAILED.equals(this.state);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("DeploymentStatus[").append(this.command).append(',');
            buf.append(this.action).append(',');
            buf.append(this.state);
            if (this.message != null) {
                buf.append(',').append(this.message);
            }
            buf.append(']');
            return buf.toString();
        }
    }
}

