/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.net.URI;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;

public class StopCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StopCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.START);
        this.kernel = kernel;
        this.modules = modules;
    }

    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            for (int i = 0; i < this.modules.length; ++i) {
                TargetModuleID module = this.modules[i];
                URI moduleID = URI.create(module.getModuleID());
                ObjectName configName = Configuration.getConfigurationObjectName((URI)moduleID);
                try {
                    this.kernel.stopGBean(configName);
                }
                catch (GBeanNotFoundException e) {
                    if (StopCommand.clean(e.getGBeanName().getKeyProperty("name")).equals(moduleID.toString())) {
                        this.updateStatus("Module " + moduleID + " is not running.");
                        continue;
                    }
                    System.out.println("Unmatched name '" + StopCommand.clean(e.getGBeanName().getKeyProperty("name")) + "'");
                    throw e;
                }
                configurationManager.unload(moduleID);
                this.addModule(module);
            }
            if (this.getModuleCount() < this.modules.length) {
                this.fail("Some modules could not be stopped");
            } else {
                this.complete("Completed");
            }
        }
        catch (Exception e) {
            this.doFail(e);
        }
    }
}

