/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.net.URI;
import java.util.List;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;

public class StartCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StartCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.START);
        this.kernel = kernel;
        this.modules = modules;
    }

    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            for (int i = 0; i < this.modules.length; ++i) {
                TargetModuleID module = this.modules[i];
                URI moduleID = URI.create(module.getModuleID());
                List list = configurationManager.loadRecursive(moduleID);
                for (int j = 0; j < list.size(); ++j) {
                    ObjectName name = (ObjectName)list.get(j);
                    this.kernel.startRecursiveGBean(name);
                    String configName = ObjectName.unquote(name.getKeyProperty("name"));
                    this.addModule(new TargetModuleIDImpl(this.modules[i].getTarget(), configName));
                }
            }
            this.complete("Completed");
        }
        catch (Exception e) {
            this.doFail(e);
        }
    }
}

