/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.plugin.TargetImpl;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.NoSuchConfigException;

public class RedeployCommand
extends AbstractDeployCommand {
    private static final String[] UNINSTALL_SIG = new String[]{URI.class.getName()};
    private final TargetModuleID[] modules;

    public RedeployCommand(Kernel kernel, TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        super(CommandType.DISTRIBUTE, kernel, moduleArchive, deploymentPlan, null, null, false);
        this.modules = moduleIDList;
    }

    public RedeployCommand(Kernel kernel, TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        super(CommandType.START, kernel, null, null, moduleArchive, deploymentPlan, true);
        this.modules = moduleIDList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block18: {
            ObjectName deployer = this.getDeployerName();
            if (deployer == null) {
                return;
            }
            try {
                try {
                    if (this.spool) {
                        if (this.moduleStream != null) {
                            this.moduleArchive = DeploymentUtil.createTempFile();
                            this.copyTo(this.moduleArchive, this.moduleStream);
                        }
                        if (this.deploymentStream != null) {
                            this.deploymentPlan = DeploymentUtil.createTempFile();
                            this.copyTo(this.deploymentPlan, this.deploymentStream);
                        }
                    }
                    ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
                    for (int i = 0; i < this.modules.length; ++i) {
                        TargetModuleIDImpl module = (TargetModuleIDImpl)this.modules[i];
                        URI configID = URI.create(module.getModuleID());
                        ObjectName configName = Configuration.getConfigurationObjectName((URI)configID);
                        try {
                            this.kernel.stopGBean(configName);
                            this.updateStatus("Stopped " + configID);
                        }
                        catch (GBeanNotFoundException e) {
                            if (!e.getGBeanName().equals(configName)) throw e;
                        }
                        try {
                            configurationManager.unload(configID);
                            this.updateStatus("Unloaded " + configID);
                        }
                        catch (InternalKernelException e) {
                            Exception cause = (Exception)e.getCause();
                            if (!(cause instanceof NoSuchConfigException)) throw cause;
                        }
                        catch (NoSuchConfigException e) {
                            // empty catch block
                        }
                        TargetImpl target = (TargetImpl)module.getTarget();
                        ObjectName storeName = target.getObjectName();
                        this.kernel.invoke(storeName, "uninstall", new Object[]{configID}, UNINSTALL_SIG);
                        this.updateStatus("Uninstalled " + configID);
                        this.doDeploy(deployer, module.getTarget(), false);
                        this.updateStatus("Deployed " + configID);
                        List list = configurationManager.loadRecursive(configID);
                        for (int j = 0; j < list.size(); ++j) {
                            ObjectName name = (ObjectName)list.get(j);
                            this.kernel.startRecursiveGBean(name);
                            this.updateStatus("Started " + RedeployCommand.clean(name.getKeyProperty("name")));
                        }
                    }
                    this.complete("Completed");
                }
                catch (Exception e) {
                    this.doFail(e);
                    Object var13_17 = null;
                    if (!this.spool) return;
                    if (this.moduleArchive != null) {
                        this.moduleArchive.delete();
                    }
                    if (this.deploymentPlan == null) return;
                    this.deploymentPlan.delete();
                    return;
                }
                Object var13_16 = null;
                if (!this.spool) return;
                if (this.moduleArchive == null) break block18;
                this.moduleArchive.delete();
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (!this.spool) throw throwable;
                if (this.moduleArchive != null) {
                    this.moduleArchive.delete();
                }
                if (this.deploymentPlan == null) throw throwable;
                this.deploymentPlan.delete();
                throw throwable;
            }
        }
        if (this.deploymentPlan == null) return;
        this.deploymentPlan.delete();
    }
}

