/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public abstract class AbstractDeployCommand
extends CommandSupport {
    private static final String DEPLOYER_NAME = "*:name=Deployer,j2eeType=Deployer,*";
    protected final Kernel kernel;
    private static final String[] DEPLOY_SIG = new String[]{File.class.getName(), File.class.getName()};
    protected final boolean spool;
    protected File moduleArchive;
    protected File deploymentPlan;
    protected InputStream moduleStream;
    protected InputStream deploymentStream;

    public AbstractDeployCommand(CommandType command, Kernel kernel, File moduleArchive, File deploymentPlan, InputStream moduleStream, InputStream deploymentStream, boolean spool) {
        super(command);
        this.kernel = kernel;
        this.moduleArchive = moduleArchive;
        this.deploymentPlan = deploymentPlan;
        this.moduleStream = moduleStream;
        this.deploymentStream = deploymentStream;
        this.spool = spool;
    }

    protected ObjectName getDeployerName() {
        Set deployers = this.kernel.listGBeans(JMXUtil.getObjectName((String)DEPLOYER_NAME));
        if (deployers.isEmpty()) {
            this.fail("No Deployer GBean present in running Geronimo server. This usually indicates a very serious problem with the configuration of your running Geronimo server.  Without a deployer running, you can't start anything at runtime (including, of course, the deployer itself).  If the deployer is present but not started, the workaround is to restart the server and explicitly require the deployer on the command line.  For a typical Geronimo configuration, use a startup command like: 'java -jar bin/server.jar org/apache/geronimo/RuntimeDeployer org/apache/geronimo/SystemDatabase'.  This should fix the deployment problem, but it will reset Geronimo to run no services or applications, so you'll need to restart anything else that ought to be running.  If the deployer service is not present at all (it was undeployed) then you need to either re-install Geronimo or get a deployment plan for the runtime deployer and distribute it while the server is not running and then start the server with a command like the above.  For help on this, write to user@geronimo.apache.org and include the contents of your config-store/index.properties and var/config/config.list files.");
            return null;
        }
        Iterator j = deployers.iterator();
        ObjectName deployer = (ObjectName)j.next();
        if (j.hasNext()) {
            this.fail("More than one deployer found");
            return null;
        }
        return deployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTo(File outfile, InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        FileOutputStream os = new FileOutputStream(outfile);
        try {
            int count;
            while ((count = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, count);
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    protected void doDeploy(ObjectName deployer, Target target, boolean finished) throws Exception {
        Object[] args = new Object[]{this.moduleArchive, this.deploymentPlan};
        List objectNames = (List)this.kernel.invoke(deployer, "deploy", args, DEPLOY_SIG);
        if (objectNames == null || objectNames.isEmpty()) {
            DeploymentException deploymentException = new DeploymentException("Got empty list");
            deploymentException.printStackTrace();
            throw deploymentException;
        }
        String parentName = (String)objectNames.get(0);
        String[] childIDs = new String[objectNames.size() - 1];
        for (int j = 0; j < childIDs.length; ++j) {
            childIDs[j] = (String)objectNames.get(j + 1);
        }
        TargetModuleIDImpl moduleID = new TargetModuleIDImpl(target, parentName.toString(), childIDs);
        this.addModule(moduleID);
        if (finished) {
            this.complete("Completed with id " + parentName);
        }
    }
}

