/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.factories;

import java.io.IOException;
import java.util.HashMap;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.deployment.plugin.DisconnectedDeploymentManager;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    public static final String URI_PREFIX = "deployer:geronimo:";

    public String getDisplayName() {
        return "Apache Geronimo";
    }

    public String getProductVersion() {
        return "1.0";
    }

    public boolean handlesURI(String uri) {
        return uri.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            return null;
        }
        return new DisconnectedDeploymentManager();
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            return null;
        }
        try {
            uri = uri.substring(URI_PREFIX.length());
            if (uri.startsWith("jmx")) {
                HashMap<String, String[]> environment = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                environment.put("jmx.remote.credentials", credentials);
                try {
                    JMXServiceURL address = new JMXServiceURL("service:" + uri);
                    JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
                    JMXDeploymentManager manager = new JMXDeploymentManager(jmxConnector);
                    return manager;
                }
                catch (IOException e) {
                    throw (DeploymentManagerCreationException)new DeploymentManagerCreationException(e.getMessage()).initCause((Throwable)e);
                }
                catch (SecurityException e) {
                    throw (AuthenticationFailedException)((Object)new AuthenticationFailedException("Invalid login.").initCause(e));
                }
            }
            throw new DeploymentManagerCreationException("Invalid URI: " + uri);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    static {
        DeploymentFactoryManager manager = DeploymentFactoryManager.getInstance();
        manager.registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
    }
}

