/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.converter.bea;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.converter.AbstractDatabasePool;
import org.apache.geronimo.converter.DOMUtils;
import org.apache.geronimo.converter.DatabaseConversionStatus;
import org.apache.geronimo.converter.JDBCPool;
import org.apache.geronimo.converter.XADatabasePool;
import org.apache.geronimo.converter.bea.Weblogic81Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebLogic81DatabaseConverter
extends DOMUtils {
    public static DatabaseConversionStatus convert(String libDir, String domainDir) throws IOException {
        Weblogic81Utils utils = new Weblogic81Utils(libDir, domainDir);
        String config = utils.getConfigXML();
        return WebLogic81DatabaseConverter.convert(new StringReader(config));
    }

    public static DatabaseConversionStatus convert(Reader configXml) throws IOException {
        ArrayList status = new ArrayList();
        ArrayList noTx = new ArrayList();
        ArrayList local = new ArrayList();
        ArrayList xa = new ArrayList();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(configXml));
            configXml.close();
            WebLogic81DatabaseConverter.parseDocument(doc, status, local, xa);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        DatabaseConversionStatus result = new DatabaseConversionStatus();
        result.setMessages(status.toArray(new String[status.size()]));
        result.setNoTXPools(noTx.toArray(new JDBCPool[noTx.size()]));
        result.setJdbcPools(local.toArray(new JDBCPool[noTx.size()]));
        result.setXaPools(xa.toArray(new XADatabasePool[xa.size()]));
        return result;
    }

    private static void parseDocument(Document doc, List status, List local, List xa) {
        Element domain = doc.getDocumentElement();
        if (!domain.getNodeName().equalsIgnoreCase("Domain")) {
            status.add("ERROR: Unrecognized file beginning with " + domain.getNodeName() + " element.  Expected a WebLogic config.xml file.");
            return;
        }
        NodeList list = domain.getChildNodes();
        HashMap<String, ConnectionPool> pools = new HashMap<String, ConnectionPool>();
        for (int i = 0; i < list.getLength(); ++i) {
            ConnectionPool pool;
            DataSource ds;
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.equalsIgnoreCase("JDBCConnectionPool")) {
                ConnectionPool pool2 = WebLogic81DatabaseConverter.getConnectionPool((Element)node, status);
                pools.put(pool2.getName(), pool2);
                continue;
            }
            if (name.equalsIgnoreCase("JDBCDataSource")) {
                ds = WebLogic81DatabaseConverter.getDataSource((Element)node, false);
                pool = (ConnectionPool)pools.get(ds.getPoolName());
                if (pool != null) {
                    pool.getDataSources().add(ds);
                    continue;
                }
                status.add("ERROR: Can't find pool for data source '" + ds.getName() + "' (" + ds.getPoolName() + ")");
                continue;
            }
            if (name.equalsIgnoreCase("JDBCTxDataSource")) {
                ds = WebLogic81DatabaseConverter.getDataSource((Element)node, true);
                pool = (ConnectionPool)pools.get(ds.getPoolName());
                if (pool != null) {
                    pool.getDataSources().add(ds);
                    continue;
                }
                status.add("ERROR: Can't find pool for data source '" + ds.getName() + "' (" + ds.getPoolName() + ")");
                continue;
            }
            status.add("Skipping element '" + name + "'");
        }
        if (pools.size() > 0) {
            Iterator it = pools.values().iterator();
            while (it.hasNext()) {
                ConnectionPool pool = (ConnectionPool)it.next();
                if (pool.getPassword() == null || !pool.getPassword().startsWith("{")) continue;
                status.add("NOTE: When importing from WebLogic, typically database passwords cannot be recovered, and will need to be re-entered.");
                break;
            }
        }
        WebLogic81DatabaseConverter.processPools(pools.values().toArray(new ConnectionPool[0]), status, local, xa);
    }

    private static void processPools(ConnectionPool[] pools, List status, List local, List xa) {
        for (int i = 0; i < pools.length; ++i) {
            boolean isXA;
            ConnectionPool pool = pools[i];
            if (pool.hasEmulate()) {
                isXA = false;
            } else if (pool.hasNonTX()) {
                isXA = false;
            } else if (pool.hasXADriverName()) {
                isXA = true;
            } else {
                isXA = false;
                status.add("Can't tell whether pool '" + pool.getName() + "' is an XA driver or not; will create local transaction pools in Geronimo.");
            }
            if (pool.getDataSources().size() == 0) {
                status.add("Pool '" + pool.getName() + "' has no associated data sources.  Creating a default pool for it.");
                if (isXA) {
                    xa.add(WebLogic81DatabaseConverter.createXAPool(pool, pool.getName(), null));
                    continue;
                }
                local.add(WebLogic81DatabaseConverter.createJDBCPool(pool, pool.getName(), null));
                continue;
            }
            for (int j = 0; j < pool.getDataSources().size(); ++j) {
                DataSource ds = (DataSource)pool.getDataSources().get(j);
                if (isXA) {
                    xa.add(WebLogic81DatabaseConverter.createXAPool(pool, ds.getName(), ds.getJndiName()));
                    continue;
                }
                local.add(WebLogic81DatabaseConverter.createJDBCPool(pool, ds.getName(), ds.getJndiName()));
            }
        }
    }

    private static void populatePool(ConnectionPool pool, AbstractDatabasePool target) {
        if (pool.getReserveTimeoutSecs() != null) {
            target.setBlockingTimeoutMillis(new Integer(pool.getReserveTimeoutSecs() * 1000));
        }
        if (pool.getIdleTimeoutSecs() != null) {
            target.setIdleTimeoutMillis(new Integer(pool.getIdleTimeoutSecs() * 1000));
        }
        target.setMaxSize(pool.getMax());
        target.setMinSize(pool.getMin());
        target.setNewConnectionSQL(pool.getInitSQL());
        target.setStatementCacheSize(pool.getCacheSize());
        target.setTestConnectionSQL(pool.getTestTable() == null ? null : "SELECT * FROM " + pool.getTestTable() + " WHERE 0=1");
        if (pool.getDriverName().toLowerCase().indexOf("oracle") > -1) {
            target.setVendor("Oracle");
        }
        if (pool.getDriverName().toLowerCase().indexOf("mysql") > -1) {
            target.setVendor("MySQL");
        }
        if (pool.getDriverName().toLowerCase().indexOf("sybase") > -1) {
            target.setVendor("Sybase");
        }
        if (pool.getDriverName().toLowerCase().indexOf("informix") > -1) {
            target.setVendor("Informix");
        }
    }

    private static JDBCPool createJDBCPool(ConnectionPool pool, String name, String jndiName) {
        JDBCPool result = new JDBCPool();
        result.setName(name);
        result.setJndiName(jndiName);
        WebLogic81DatabaseConverter.populatePool(pool, result);
        result.setConnectionProperties(pool.getProperties());
        result.setDriverClass(pool.getDriverName());
        result.setJdbcURL(pool.getUrl());
        if (pool.getPassword() != null && !pool.getPassword().startsWith("{")) {
            result.setPassword(pool.getPassword());
        }
        result.setUsername(pool.getUsername());
        return result;
    }

    private static XADatabasePool createXAPool(ConnectionPool pool, String name, String jndiName) {
        XADatabasePool result = new XADatabasePool();
        result.setName(name);
        result.setJndiName(jndiName);
        WebLogic81DatabaseConverter.populatePool(pool, result);
        result.setXaDataSourceClass(pool.getDriverName());
        result.setProperties(pool.getProperties());
        return result;
    }

    private static DataSource getDataSource(Element root, boolean tx) {
        DataSource ds = new DataSource();
        ds.setDeclaredAsTX(tx);
        ds.setEmulate(WebLogic81DatabaseConverter.getBoolean(root.getAttribute("EnableTwoPhaseCommit"), false));
        ds.setName(root.getAttribute("Name"));
        ds.setJndiName(root.getAttribute("JNDIName"));
        ds.setPoolName(root.getAttribute("PoolName"));
        return ds;
    }

    private static boolean getBoolean(String value, boolean defaultResult) {
        if (value == null) {
            return defaultResult;
        }
        return new Boolean(value);
    }

    private static ConnectionPool getConnectionPool(Element root, List status) {
        ConnectionPool pool = new ConnectionPool();
        pool.setName(root.getAttribute("Name"));
        pool.setDriverName(root.getAttribute("DriverName"));
        pool.setUrl(root.getAttribute("URL"));
        pool.setMin(WebLogic81DatabaseConverter.getInteger(root.getAttribute("InitialCapacity")));
        pool.setMax(WebLogic81DatabaseConverter.getInteger(root.getAttribute("MaxCapacity")));
        WebLogic81DatabaseConverter.readProperties(pool.getProperties(), root.getAttribute("Properties"), status);
        pool.setUsername(pool.getProperties().getProperty("user"));
        pool.getProperties().remove("user");
        if (root.hasAttribute("Password")) {
            pool.setPassword(root.getAttribute("Password"));
        } else if (root.hasAttribute("PasswordEncrypted")) {
            pool.setPassword(root.getAttribute("PasswordEncrypted"));
        }
        pool.setReserveTimeoutSecs(WebLogic81DatabaseConverter.getInteger(root.getAttribute("ConnectionReserveTimeoutSeconds")));
        pool.setIdleTimeoutSecs(WebLogic81DatabaseConverter.getInteger(root.getAttribute("InactiveConnectionTimeoutSeconds")));
        pool.setCacheSize(WebLogic81DatabaseConverter.getInteger(root.getAttribute("StatementCacheSize")));
        pool.setInitSQL(root.getAttribute("InitSQL"));
        pool.setTestTable(root.getAttribute("TestTableName"));
        return pool;
    }

    private static void readProperties(Properties props, String value, List status) {
        int eq;
        String s;
        if (value == null) {
            return;
        }
        if ((value = value.trim()).equals("")) {
            return;
        }
        int last = -1;
        int pos = value.indexOf(59);
        while (pos > -1) {
            s = value.substring(last + 1, pos);
            eq = s.indexOf(61);
            if (eq > -1) {
                props.setProperty(s.substring(0, eq), s.substring(eq + 1));
            } else {
                status.add("WARN: Unable to read property '" + s + "'");
            }
            last = pos;
            pos = value.indexOf(59, pos + 1);
        }
        s = value.substring(last + 1);
        eq = s.indexOf(61);
        if (eq > -1) {
            props.setProperty(s.substring(0, eq), s.substring(eq + 1));
        } else {
            status.add("WARN: Unable to read property '" + s + "'");
        }
    }

    private static Integer getInteger(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).equals("")) {
            return null;
        }
        return new Integer(value);
    }

    public static class ConnectionPool {
        private String name;
        private String driverName;
        private Integer min;
        private Integer max;
        private String url;
        private String username;
        private String password;
        private Integer reserveTimeoutSecs;
        private Integer idleTimeoutSecs;
        private Integer cacheSize;
        private String initSQL;
        private String testTable;
        private Properties properties = new Properties();
        private List dataSources = new ArrayList();

        public boolean hasEmulate() {
            for (int i = 0; i < this.dataSources.size(); ++i) {
                DataSource ds = (DataSource)this.dataSources.get(i);
                if (!ds.isEmulate()) continue;
                return true;
            }
            return false;
        }

        public boolean hasNonTX() {
            for (int i = 0; i < this.dataSources.size(); ++i) {
                DataSource ds = (DataSource)this.dataSources.get(i);
                if (ds.isDeclaredAsTX()) continue;
                return true;
            }
            return false;
        }

        public boolean hasXADriverName() {
            return this.driverName.toUpperCase().indexOf("XA") > -1;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDriverName() {
            return this.driverName;
        }

        public void setDriverName(String driverName) {
            this.driverName = driverName;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getInitSQL() {
            return this.initSQL;
        }

        public void setInitSQL(String initSQL) {
            this.initSQL = initSQL;
        }

        public String getTestTable() {
            return this.testTable;
        }

        public void setTestTable(String testTable) {
            this.testTable = testTable;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public List getDataSources() {
            return this.dataSources;
        }

        public void setDataSources(List dataSources) {
            this.dataSources = dataSources;
        }

        public Integer getMin() {
            return this.min;
        }

        public void setMin(Integer min) {
            this.min = min;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }

        public Integer getReserveTimeoutSecs() {
            return this.reserveTimeoutSecs;
        }

        public void setReserveTimeoutSecs(Integer reserveTimeoutSecs) {
            this.reserveTimeoutSecs = reserveTimeoutSecs;
        }

        public Integer getIdleTimeoutSecs() {
            return this.idleTimeoutSecs;
        }

        public void setIdleTimeoutSecs(Integer idleTimeoutSecs) {
            this.idleTimeoutSecs = idleTimeoutSecs;
        }

        public Integer getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class DataSource {
        private String name;
        private String poolName;
        private String jndiName;
        private boolean emulate;
        private boolean declaredAsTX;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }

        public boolean isEmulate() {
            return this.emulate;
        }

        public void setEmulate(boolean emulate) {
            this.emulate = emulate;
        }

        public boolean isDeclaredAsTX() {
            return this.declaredAsTX;
        }

        public void setDeclaredAsTX(boolean declaredAsTX) {
            this.declaredAsTX = declaredAsTX;
        }
    }
}

