/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.web.taglib;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.servlet.jsp.JspWriter;
import org.apache.geronimo.console.web.taglib.MBeanServerContextSupport;
import org.apache.geronimo.console.web.taglib.MBeanServerContextTag;
import org.apache.geronimo.console.web.util.ObjectInstanceComparator;

public final class MBeanServerContentsTag
extends MBeanServerContextSupport {
    private MBeanServerContextTag ctx;
    private MBeanServer server;

    public int doStartTag() {
        this.ctx = this.getMBeanServerContext();
        this.server = this.ctx.getMBeanServer();
        JspWriter out = this.pageContext.getOut();
        try {
            if (this.server != null) {
                ObjectName objectName = new ObjectName(this.ctx.getObjectNameFilter());
                QueryExp query = null;
                Set<ObjectInstance> results = this.server.queryMBeans(objectName, query);
                List mbeans = this.toList(results);
                this.printMBeanStack(out, mbeans);
            }
        }
        catch (MalformedObjectNameException e) {
            try {
                String s = "Your query string was improperly formatted. Please try another query.";
                out.println("<div class='paragraphHead'> Invalid Query String </div>");
                out.println("<p>" + s + "</p>");
            }
            catch (IOException ex) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public int doEndTag() {
        return 6;
    }

    private void printMBeanStack(JspWriter out, List mbeans) throws IOException {
        Iterator iter = mbeans.iterator();
        String currentDomain = "";
        int i = 0;
        while (iter.hasNext()) {
            ObjectInstance instance = (ObjectInstance)iter.next();
            ObjectName name = instance.getObjectName();
            if (!name.getDomain().equals(currentDomain)) {
                if (i != 0) {
                    out.println("</ul>\n");
                }
                currentDomain = name.getDomain();
                out.println("\n<div class='paragraphHead'>" + currentDomain + "</div>");
                out.println("<ul class='mbeanList'>");
            }
            String cName = name.getCanonicalName();
            String encodedName = URLEncoder.encode(cName, "UTF-8");
            String output = cName.substring(cName.indexOf(":") + 1);
            out.println("<li><a href=\"mbeanInfo.jsp?MBeanName=" + encodedName + "\">" + URLDecoder.decode(output, "UTF-8") + "</a></li>");
            ++i;
        }
        out.println("</ul>\n");
        out.println("<br/> Number of MBeans == " + i);
    }

    private void printCascadingDefinition(JspWriter out, String output) {
    }

    private List toList(Set set) {
        ArrayList list = new ArrayList();
        list.addAll(set);
        ObjectInstanceComparator comparator = new ObjectInstanceComparator();
        Collections.sort(list, comparator);
        return list;
    }
}

