/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.web.taglib;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.servlet.jsp.JspWriter;
import org.apache.geronimo.console.web.taglib.MBeanServerContextSupport;
import org.apache.geronimo.console.web.taglib.MBeanServerContextTag;
import org.apache.geronimo.console.web.util.MBeanAttributesComparator;

public final class MBeanAttributesTag
extends MBeanServerContextSupport {
    private Hashtable properties;
    private MBeanServerContextTag ctx;
    private ObjectInstance instance;
    private Object[] keys;
    private Set keySet;
    private ObjectName name;
    private MBeanServer server;

    public int doEndTag() {
        return 6;
    }

    public int doStartTag() {
        this.ctx = this.getMBeanServerContext();
        this.server = this.ctx.getMBeanServer();
        JspWriter out = this.pageContext.getOut();
        this.printMBeanProperties(out);
        this.printMBeanAttributes(out);
        return 1;
    }

    private String getDomain() {
        try {
            ObjectName mbeanName = new ObjectName(this.getMBeanName());
            QueryExp query = null;
            Set<ObjectInstance> results = this.server.queryMBeans(mbeanName, query);
            this.instance = results.iterator().next();
            this.name = this.instance.getObjectName();
            return this.name.getDomain();
        }
        catch (MalformedObjectNameException e) {
            return "No object to introspect.  Choose one from the MBean Stack View.";
        }
    }

    private String getMBeanName() {
        String s = this.pageContext.getRequest().getParameter("MBeanName");
        if (s == null || s == "") {
            return null;
        }
        return s;
    }

    private void printMBeanProperties(JspWriter out) {
        try {
            out.println("<table cellpadding=\"0\" cellspacing=\"0\">");
            out.println("\t<tr class=\"head\">");
            out.println("\t\t<td class=\"head\" colspan=\"3\">MBean Properties</td>");
            out.println("\t</tr>");
            out.println("\t<tr class=\"one\">");
            out.println("\t\t<td class=\"name\">MBean Domain</td>");
            out.println("\t\t<td class=\"center\">=</td>");
            out.println("\t\t<td class=\"value\">" + this.getDomain() + "</td>");
            out.println("\t</tr>");
            this.printMBeanPropertiesStack(out);
            out.println("</table>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printMBeanPropertiesStack(JspWriter out) {
        this.properties = this.name.getKeyPropertyList();
        this.keySet = this.properties.keySet();
        this.keys = this.toList(this.keySet).toArray();
        try {
            String trClass = "one";
            for (int i = 0; i < this.keys.length; ++i) {
                String key = (String)this.keys[i];
                String property = this.name.getKeyProperty(key);
                if (i % 2 == 0) {
                    trClass = "two";
                } else if (i % 2 == 1) {
                    trClass = "one";
                }
                out.println("\t<tr class=\"" + trClass + "\">");
                out.println("\t\t<td class=\"name\">" + key + "</td>");
                out.println("\t\t<td class=\"center\">=</td>");
                out.println("\t\t<td class=\"value\">" + URLDecoder.decode(property, "UTF-8") + "</td>");
                out.println("\t</tr>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printMBeanAttributes(JspWriter out) {
        try {
            out.println("<table cellpadding=\"0\" cellspacing=\"0\">");
            out.println("\t<tr class=\"head\">");
            out.println("\t\t<td class=\"head\" colspan=\"3\">MBean Attributes & Info</td>");
            out.println("\t</tr>");
            this.printMBeanAttributesStack(out);
            out.println("</table>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printMBeanAttributesStack(JspWriter out) {
        try {
            MBeanInfo info = this.server.getMBeanInfo(this.name);
            MBeanAttributeInfo[] attributes = info.getAttributes();
            String className = info.getClassName();
            String description = info.getDescription();
            out.println("\t<tr class=\"one\">");
            out.println("\t\t<td class=\"name\">Class Name</td>");
            out.println("\t\t<td class=\"center\">=</td>");
            out.println("\t\t<td class=\"value\">" + className + "</td>");
            out.println("\t</tr>");
            out.println("\t<tr class=\"two\">");
            out.println("\t\t<td class=\"name\">Description</td>");
            out.println("\t\t<td class=\"center\">=</td>");
            out.println("\t\t<td class=\"value\">" + description + "</td>");
            out.println("\t</tr>");
            String attributeName = "name";
            String value = "value";
            String trClass = "one";
            for (int i = 0; i < attributes.length; ++i) {
                Object attrObj;
                attributeName = attributes[i].getName();
                if (!attributes[i].isReadable() || (attrObj = this.server.getAttribute(this.name, attributeName)) == null) continue;
                value = attrObj.toString();
                if (i % 2 == 0) {
                    trClass = "one";
                } else if (i % 2 == 1) {
                    trClass = "two";
                }
                out.println("\t<tr class=\"" + trClass + "\">");
                out.println("\t\t<td class=\"name\">" + attributeName + "</td>");
                out.println("\t\t<td class=\"center\">=</td>");
                out.println("\t\t<td class=\"value\">" + URLDecoder.decode(value, "UTF-8") + "</td>");
                out.println("\t</tr>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List toList(Set set) {
        ArrayList list = new ArrayList();
        MBeanAttributesComparator comp = new MBeanAttributesComparator();
        list.addAll(set);
        Collections.sort(list, comp);
        return list;
    }
}

