/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import [Ljava.lang.String;;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;

public class ResourceAdapterModuleImpl {
    private final Kernel kernel;
    private final String baseName;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final String deploymentDescriptor;
    public static final GBeanInfo GBEAN_INFO;

    public ResourceAdapterModuleImpl(Kernel kernel, String objectName, J2EEServer server, J2EEApplication application, String deploymentDescriptor) {
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        Hashtable<String, String> keyPropertyList = myObjectName.getKeyPropertyList();
        String name = keyPropertyList.get("name");
        String j2eeServerName = keyPropertyList.get("J2EEServer");
        String j2eeApplicationName = keyPropertyList.get("J2EEApplication");
        this.baseName = myObjectName.getDomain() + ":J2EEServer=" + j2eeServerName + ",J2EEApplication=" + j2eeApplicationName + ",ResouceAdapterModule=" + name + ",";
        this.kernel = kernel;
        this.server = server;
        this.application = application;
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    public String[] getResourceAdapters() throws MalformedObjectNameException {
        return Util.getObjectNames((Kernel)this.kernel, (Object)this.baseName, (String[])new String[]{"ResourceAdapter"});
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"ResourceAdapterModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name j2eeType property must be 'ResourceAdapterModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("ResourceAdapterModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ResourceAdapterModuleImpl.class);
        infoFactory.addReference("J2EEServer", J2EEServer.class);
        infoFactory.addReference("J2EEApplication", J2EEApplication.class);
        infoFactory.addAttribute("deploymentDescriptor", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("server", String.class, false);
        infoFactory.addAttribute("application", String.class, false);
        infoFactory.addAttribute("javaVMs", String;.class, false);
        infoFactory.addAttribute("resourceAdapters", String;.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "J2EEServer", "J2EEApplication", "deploymentDescriptor"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

