/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.client.AppClientContainer;
import org.apache.geronimo.client.StaticJndiContextPlugin;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.management.impl.J2EEAppClientModuleImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deployment.SecurityBuilder;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientDocument;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientType;
import org.apache.geronimo.xbeans.geronimo.client.GerResourceType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.geronimo.security.GerDefaultPrincipalType;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientDocument;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientType;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class AppClientModuleBuilder
implements ModuleBuilder {
    private static final Log log;
    private static final String LINE_SEP;
    private final Environment defaultClientEnvironment;
    private final Environment defaultServerEnvironment;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final AbstractNameQuery transactionContextManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final SingleElementCollection ejbReferenceBuilder;
    private final SingleElementCollection connectorModuleBuilder;
    private final SingleElementCollection resourceReferenceBuilder;
    private final SingleElementCollection serviceReferenceBuilder;
    private static final String GERAPPCLIENT_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionContextManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, EJBReferenceBuilder ejbReferenceBuilder, ModuleBuilder connectorModuleBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ServiceReferenceBuilder serviceReferenceBuilder) {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionContextManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, new SingleElementCollection((Object)ejbReferenceBuilder), new SingleElementCollection((Object)connectorModuleBuilder), new SingleElementCollection((Object)resourceReferenceBuilder), new SingleElementCollection((Object)serviceReferenceBuilder));
    }

    public AppClientModuleBuilder(AbstractNameQuery transactionContextManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Collection ejbReferenceBuilder, Collection connectorModuleBuilder, Collection resourceReferenceBuilder, Collection serviceReferenceBuilder, Environment defaultClientEnvironment, Environment defaultServerEnvironment) {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionContextManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, new SingleElementCollection(ejbReferenceBuilder), new SingleElementCollection(connectorModuleBuilder), new SingleElementCollection(resourceReferenceBuilder), new SingleElementCollection(serviceReferenceBuilder));
    }

    private AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionContextManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, SingleElementCollection ejbReferenceBuilder, SingleElementCollection connectorModuleBuilder, SingleElementCollection resourceReferenceBuilder, SingleElementCollection serviceReferenceBuilder) {
        this.defaultClientEnvironment = defaultClientEnvironment;
        this.defaultServerEnvironment = defaultServerEnvironment;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.connectorModuleBuilder = connectorModuleBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
    }

    private EJBReferenceBuilder getEjbReferenceBuilder() {
        return (EJBReferenceBuilder)this.ejbReferenceBuilder.getElement();
    }

    private ModuleBuilder getConnectorModuleBuilder() {
        return (ModuleBuilder)this.connectorModuleBuilder.getElement();
    }

    private ResourceReferenceBuilder getResourceReferenceBuilder() {
        return (ResourceReferenceBuilder)this.resourceReferenceBuilder.getElement();
    }

    private ServiceReferenceBuilder getServiceReferenceBuilder() {
        return (ServiceReferenceBuilder)this.serviceReferenceBuilder.getElement();
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, "app-client", null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, earName, naming, idBuilder);
    }

    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        ApplicationClientType appClient;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        if (!$assertionsDisabled && earName == null != (earEnvironment == null)) {
            throw new AssertionError((Object)"if earName is not null you must supply earEnvironment as well");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/application-client.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
            ApplicationClientDocument appClientDoc = SchemaConversionUtils.convertToApplicationClientSchema((XmlObject)xmlObject);
            appClient = appClientDoc.getApplicationClient();
        }
        catch (XmlException e) {
            throw new DeploymentException("Unable to parse application-client.xml", (Throwable)e);
        }
        boolean standAlone = earEnvironment == null;
        GerApplicationClientType gerAppClient = this.getGeronimoAppClient(plan, moduleFile, standAlone, targetPath, appClient, earEnvironment);
        EnvironmentType clientEnvironmentType = gerAppClient.getClientEnvironment();
        Environment clientEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)clientEnvironmentType, (Environment)this.defaultClientEnvironment);
        if (standAlone) {
            String name = new File(moduleFile.getName()).getName();
            idBuilder.resolve(clientEnvironment, name + "_" + name, "jar");
        } else {
            Artifact earConfigId = earEnvironment.getConfigId();
            idBuilder.resolve(clientEnvironment, earConfigId.getArtifactId() + "_" + new File(moduleFile.getName()).getName(), "jar");
        }
        EnvironmentType serverEnvironmentType = gerAppClient.getServerEnvironment();
        Environment serverEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)serverEnvironmentType, (Environment)this.defaultServerEnvironment);
        if (!standAlone) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)serverEnvironment);
            serverEnvironment = earEnvironment;
            if (!serverEnvironment.getConfigId().isResolved()) {
                throw new IllegalStateException("Server environment module ID should be fully resolved (not " + serverEnvironment.getConfigId() + ")");
            }
        } else {
            idBuilder.resolve(serverEnvironment, new File(moduleFile.getName()).getName(), "jar");
        }
        if (earName == null) {
            earName = naming.createRootName(earEnvironment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, earEnvironment.getConfigId().toString(), "AppClientModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "AppClientModule");
        }
        return new AppClientModule(standAlone, moduleName, serverEnvironment, clientEnvironment, moduleFile, targetPath, (XmlObject)appClient, (XmlObject)gerAppClient, specDD);
    }

    GerApplicationClientType getGeronimoAppClient(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, ApplicationClientType appClient, Environment environment) throws DeploymentException {
        GerApplicationClientType gerAppClient;
        XmlObject rawPlan = null;
        try {
            Object path;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((File)((File)plan));
                } else {
                    path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-application-client.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (rawPlan != null) {
                gerAppClient = (GerApplicationClientType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)GerApplicationClientDocument.type.getDocumentElementName(), (SchemaType)GerApplicationClientType.type);
            } else {
                path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                gerAppClient = this.createDefaultPlan((String)path, appClient, standAlone, environment);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        return gerAppClient;
    }

    private GerApplicationClientType createDefaultPlan(String name, ApplicationClientType appClient, boolean standAlone, Environment environment) {
        String id = appClient.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        GerApplicationClientType geronimoAppClient = GerApplicationClientType.Factory.newInstance();
        EnvironmentType clientEnvironmentType = geronimoAppClient.addNewClientEnvironment();
        EnvironmentType serverEnvironmentType = geronimoAppClient.addNewServerEnvironment();
        return geronimoAppClient;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        File appClientDir;
        JarFile moduleFile = module.getModuleFile();
        try {
            earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName());
        }
        AppClientModule appClientModule = (AppClientModule)module;
        appClientModule.setEarFile(earFile);
        Environment clientEnvironment = appClientModule.getClientEnvironment();
        if (!appClientModule.isStandAlone() || clientEnvironment.getConfigId() == null) {
            Artifact earConfigId = earContext.getConfigID();
            Artifact configId = new Artifact(earConfigId.getGroupId(), earConfigId.getArtifactId() + "_" + module.getTargetPath(), earConfigId.getVersion(), "car");
            clientEnvironment.setConfigId(configId);
        }
        AbstractName clientBaseName = earContext.getNaming().createRootName(clientEnvironment.getConfigId(), clientEnvironment.getConfigId().toString(), "J2EEApplication");
        try {
            appClientDir = targetConfigurationStore.createNewConfigurationDir(clientEnvironment.getConfigId());
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
        try {
            EARContext appClientDeploymentContext = new EARContext(appClientDir, null, clientEnvironment, ConfigurationModuleType.CAR, earContext.getNaming(), earContext.getConfigurationManager(), null, clientBaseName, this.transactionContextManagerObjectName, this.connectionTrackerObjectName, null, null, this.corbaGBeanObjectName, new RefContext(this.getEjbReferenceBuilder(), this.getResourceReferenceBuilder(), this.getServiceReferenceBuilder()));
            appClientModule.setEarContext(appClientDeploymentContext);
        }
        catch (DeploymentException e) {
            this.cleanupAppClientDir(appClientDir);
            throw e;
        }
    }

    public void initContext(EARContext earContext, Module clientModule, ClassLoader cl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGBeans(EARContext earContext, Module module, ClassLoader earClassLoader, Collection repositories) throws DeploymentException {
        String mainClasss;
        AppClientModule appClientModule = (AppClientModule)module;
        ApplicationClientType appClient = (ApplicationClientType)appClientModule.getSpecDD();
        GerApplicationClientType geronimoAppClient = (GerApplicationClientType)appClientModule.getVendorDD();
        JarFile moduleFile = module.getModuleFile();
        try {
            Manifest manifest = moduleFile.getManifest();
            if (manifest == null) {
                throw new DeploymentException("App client module jar does not contain a manifest: " + moduleFile.getName());
            }
            mainClasss = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (mainClasss == null) {
                throw new DeploymentException("App client module jar does not have Main-Class defined in the manifest: " + moduleFile.getName());
            }
            String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (module.isStandAlone() && classPath != null) {
                throw new DeploymentException("Manifest class path entry is not allowed in a standalone jar (J2EE 1.4 Section 8.2)");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not get manifest from app client module: " + moduleFile.getName());
        }
        AbstractName appClientModuleName = appClientModule.getModuleName();
        GBeanData appClientModuleGBeanData = new GBeanData(appClientModuleName, J2EEAppClientModuleImpl.GBEAN_INFO);
        try {
            appClientModuleGBeanData.setReferencePatterns("J2EEServer", Collections.singleton(earContext.getServerName()));
            if (!module.isStandAlone()) {
                appClientModuleGBeanData.setReferencePatterns("J2EEApplication", Collections.singleton(earContext.getModuleName()));
            }
            appClientModuleGBeanData.setAttribute("deploymentDescriptor", (Object)appClientModule.getOriginalSpecDD());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
        }
        try {
            earContext.addGBean(appClientModuleGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add application client module gbean to configuration", (Throwable)e);
        }
        EARContext appClientDeploymentContext = appClientModule.getEarContext();
        ModuleIDBuilder idBuilder = new ModuleIDBuilder();
        idBuilder.setDefaultGroup(appClientModule.getClientEnvironment().getConfigId().getGroupId());
        idBuilder.setDefaultVersion(appClientModule.getClientEnvironment().getConfigId().getVersion());
        try {
            try {
                MessageDestinationType[] messageDestinations = appClient.getMessageDestinationArray();
                GerMessageDestinationType[] gerMessageDestinations = geronimoAppClient.getMessageDestinationArray();
                ENCConfigBuilder.registerMessageDestinations((RefContext)appClientDeploymentContext.getRefContext(), (String)appClientModule.getName(), (MessageDestinationType[])messageDestinations, (GerMessageDestinationType[])gerMessageDestinations);
                URI moduleBase = new URI(appClientModule.getTargetPath());
                try {
                    appClientDeploymentContext.addIncludeAsPackedJar(moduleBase, moduleFile);
                }
                catch (IOException e) {
                    throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName());
                }
                this.addManifestClassPath((DeploymentContext)appClientDeploymentContext, appClientModule.getEarFile(), moduleFile, moduleBase);
                ClassLoader appClientClassLoader = appClientDeploymentContext.getClassLoader();
                if (geronimoAppClient != null) {
                    Iterator iterator4;
                    GbeanType[] gbeans = geronimoAppClient.getGbeanArray();
                    ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)appClientClassLoader, (AbstractName)appClientDeploymentContext.getModuleName(), (DeploymentContext)appClientDeploymentContext);
                    ArrayList<Module> resourceModules = new ArrayList<Module>();
                    try {
                        Module connectorModule;
                        GerResourceType[] resources = geronimoAppClient.getResourceArray();
                        for (int i = 0; i < resources.length; ++i) {
                            void var25_35;
                            String path;
                            GerResourceType resource = resources[i];
                            if (resource.isSetExternalRar()) {
                                path = resource.getExternalRar().trim();
                                Artifact artifact = Artifact.create((String)path);
                                File file = null;
                                Iterator iterator2 = repositories.iterator();
                                while (iterator2.hasNext()) {
                                    Repository repository = (Repository)iterator2.next();
                                    if (!repository.contains(artifact)) continue;
                                    file = repository.getLocation(artifact);
                                    break;
                                }
                                if (file == null) {
                                    throw new DeploymentException("Missing rar in repositories: " + path);
                                }
                                try {
                                    JarFile jarFile = new JarFile(file);
                                }
                                catch (IOException e) {
                                    throw new DeploymentException("Could not access rar contents", (Throwable)e);
                                }
                            }
                            path = resource.getInternalRar();
                            try {
                                NestedJarFile nestedJarFile = new NestedJarFile(appClientModule.getEarFile(), path);
                            }
                            catch (IOException e) {
                                throw new DeploymentException("Could not locate connector inside ear", (Throwable)e);
                            }
                            GerConnectorType connectorPlan = resource.getConnector();
                            Module connectorModule2 = this.getConnectorModuleBuilder().createModule((Object)connectorPlan, (JarFile)var25_35, path, null, appClientModule.getClientEnvironment(), null, appClientDeploymentContext.getModuleName(), earContext.getNaming(), idBuilder);
                            resourceModules.add(connectorModule2);
                            this.getConnectorModuleBuilder().installModule((JarFile)var25_35, appClientDeploymentContext, connectorModule2, null, null, repositories);
                        }
                        appClientClassLoader = appClientDeploymentContext.getClassLoader();
                        Iterator iterator3 = resourceModules.iterator();
                        while (iterator3.hasNext()) {
                            connectorModule = (Module)iterator3.next();
                            this.getConnectorModuleBuilder().initContext(appClientDeploymentContext, connectorModule, appClientClassLoader);
                        }
                        iterator3 = resourceModules.iterator();
                        while (iterator3.hasNext()) {
                            connectorModule = (Module)iterator3.next();
                            this.getConnectorModuleBuilder().addGBeans(appClientDeploymentContext, connectorModule, appClientClassLoader, repositories);
                        }
                        Object var31_45 = null;
                        iterator4 = resourceModules.iterator();
                    }
                    catch (Throwable throwable) {
                        Object var31_46 = null;
                        Iterator iterator4 = resourceModules.iterator();
                        while (iterator4.hasNext()) {
                            Module connectorModule = (Module)iterator4.next();
                            connectorModule.close();
                        }
                        throw throwable;
                    }
                    while (iterator4.hasNext()) {
                        Module connectorModule = (Module)iterator4.next();
                        connectorModule.close();
                    }
                }
                AbstractName jndiContextName = earContext.getNaming().createChildName(appClientDeploymentContext.getModuleName(), "StaticJndiContext", "StaticJndiContext");
                GBeanData jndiContextGBeanData = new GBeanData(jndiContextName, StaticJndiContextPlugin.GBEAN_INFO);
                try {
                    Map componentContext = this.buildComponentContext(appClientDeploymentContext, earContext, appClientModule, appClient, geronimoAppClient, appClientClassLoader);
                    jndiContextGBeanData.setAttribute("context", (Object)componentContext);
                }
                catch (DeploymentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to construct jndi context for AppClientModule GBean", (Throwable)e);
                }
                appClientDeploymentContext.addGBean(jndiContextGBeanData);
                AbstractName appClientContainerName = appClientDeploymentContext.getModuleName();
                GBeanData appClientContainerGBeanData = new GBeanData(appClientContainerName, AppClientContainer.GBEAN_INFO);
                try {
                    appClientContainerGBeanData.setAttribute("mainClassName", (Object)mainClasss);
                    appClientContainerGBeanData.setAttribute("appClientModuleName", (Object)appClientModuleName);
                    String callbackHandlerClassName = null;
                    if (appClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = appClient.getCallbackHandler().getStringValue().trim();
                    }
                    if (geronimoAppClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = geronimoAppClient.getCallbackHandler().trim();
                    }
                    String realmName = null;
                    if (geronimoAppClient.isSetRealmName()) {
                        realmName = geronimoAppClient.getRealmName().trim();
                    }
                    if (callbackHandlerClassName != null && realmName == null) {
                        throw new DeploymentException("You must specify a realm name with the callback handler");
                    }
                    if (realmName != null) {
                        appClientContainerGBeanData.setAttribute("realmName", (Object)realmName);
                        appClientContainerGBeanData.setAttribute("callbackHandlerClassName", (Object)callbackHandlerClassName);
                    } else if (geronimoAppClient.isSetDefaultPrincipal()) {
                        DefaultPrincipal defaultPrincipal = SecurityBuilder.buildDefaultPrincipal((GerDefaultPrincipalType)geronimoAppClient.getDefaultPrincipal());
                        appClientContainerGBeanData.setAttribute("defaultPrincipal", (Object)defaultPrincipal);
                    }
                    appClientContainerGBeanData.setReferencePattern("JNDIContext", jndiContextName);
                    appClientContainerGBeanData.setReferencePattern("TransactionContextManager", this.transactionContextManagerObjectName);
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
                }
                appClientDeploymentContext.addGBean(appClientContainerGBeanData);
                earContext.addAdditionalDeployment(appClientDeploymentContext.getConfigurationData());
                Object var35_52 = null;
                if (appClientDeploymentContext == null) return;
            }
            catch (Throwable throwable) {
                Object var35_53 = null;
                if (appClientDeploymentContext == null) throw throwable;
                try {
                    appClientDeploymentContext.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                appClientDeploymentContext.close();
                return;
            }
            catch (IOException e) {}
            return;
        }
        catch (Throwable e) {
            File appClientDir = appClientDeploymentContext.getBaseDir();
            this.cleanupAppClientDir(appClientDir);
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (!(e instanceof Exception)) throw new Error(e);
            throw new DeploymentException(e);
        }
    }

    public String getSchemaNamespace() {
        return GERAPPCLIENT_NAMESPACE;
    }

    public void addManifestClassPath(DeploymentContext deploymentContext, JarFile earFile, JarFile jarFile, URI jarFileLocation) throws DeploymentException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + jarFileLocation);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            JarFile classPathJarFile;
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            URI classPathJarLocation = jarFileLocation.resolve(pathUri);
            File classPathFile = deploymentContext.getTargetFile(classPathJarLocation);
            if (classPathFile.exists()) continue;
            ZipEntry entry = earFile.getEntry(classPathJarLocation.getPath());
            if (entry == null) {
                throw new DeploymentException("Cound not find manifest class path entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            try {
                deploymentContext.addFile(classPathJarLocation, (ZipFile)earFile, entry);
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not copy manifest class path entry into configuration: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            try {
                classPathJarFile = new JarFile(classPathFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Manifest class path entries must be a valid jar file (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            this.addManifestClassPath(deploymentContext, earFile, classPathJarFile, classPathJarLocation);
        }
    }

    private Map buildComponentContext(EARContext appClientContext, EARContext ejbContext, AppClientModule appClientModule, ApplicationClientType appClient, GerApplicationClientType geronimoAppClient, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.buildComponentContext((EARContext)appClientContext, (Configuration)ejbContext.getConfiguration(), (Module)appClientModule, null, (EnvEntryType[])appClient.getEnvEntryArray(), (EjbRefType[])appClient.getEjbRefArray(), (GerEjbRefType[])geronimoAppClient.getEjbRefArray(), (EjbLocalRefType[])new EjbLocalRefType[0], null, (ResourceRefType[])appClient.getResourceRefArray(), (GerResourceRefType[])geronimoAppClient.getResourceRefArray(), (ResourceEnvRefType[])appClient.getResourceEnvRefArray(), (GerResourceEnvRefType[])geronimoAppClient.getResourceEnvRefArray(), (MessageDestinationRefType[])appClient.getMessageDestinationRefArray(), (ServiceRefType[])appClient.getServiceRefArray(), (GerServiceRefType[])geronimoAppClient.getServiceRefArray(), (GerGbeanRefType[])geronimoAppClient.getGbeanRefArray(), (ClassLoader)cl);
    }

    private boolean cleanupAppClientDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !AppClientModuleBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)AppClientModuleBuilder.class);
        LINE_SEP = System.getProperty("line.separator");
        GERAPPCLIENT_NAMESPACE = GerApplicationClientDocument.type.getDocumentElementName().getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)AppClientModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultClientEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultServerEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("transactionContextManagerObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("connectionTrackerObjectName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("corbaGBeanObjectName", AbstractNameQuery.class, true);
        infoBuilder.addReference("EJBReferenceBuilder", EJBReferenceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ConnectorModuleBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceReferenceBuilder", ResourceReferenceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceReferenceBuilder", ServiceReferenceBuilder.class, "ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"transactionContextManagerObjectName", "connectionTrackerObjectName", "corbaGBeanObjectName", "EJBReferenceBuilder", "ConnectorModuleBuilder", "ResourceReferenceBuilder", "ServiceReferenceBuilder", "defaultClientEnvironment", "defaultServerEnvironment"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

