/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.server;

import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.OperationType;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.w3c.dom.Element;

public class AxisWebServiceContainer
implements WebServiceContainer {
    public static final String REQUEST = AxisWebServiceContainer.class.getName() + "@Request";
    public static final String RESPONSE = AxisWebServiceContainer.class.getName() + "@Response";
    public static final String LOCATION_REPLACEMENT_TOKEN = "LOCATIONREPLACEMENTTOKEN";
    private static Log log = LogFactory.getLog((Class)AxisWebServiceContainer.class);
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private final URI location;
    private final URI wsdlLocation;
    private final SOAPService service;
    private final transient ClassLoader classLoader;
    private final Map wsdlMap;

    public AxisWebServiceContainer(URI location, URI wsdlURL, SOAPService service, Map wsdlMap, ClassLoader classLoader) {
        this.location = location;
        this.wsdlLocation = wsdlURL;
        this.service = service;
        this.wsdlMap = wsdlMap;
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(WebServiceContainer.Request req, WebServiceContainer.Response res) throws Exception {
        MessageContext messageContext = new MessageContext(null);
        req.setAttribute(MESSAGE_CONTEXT, (Object)messageContext);
        messageContext.setClassLoader(this.classLoader);
        Message responseMessage = null;
        String contentType = req.getHeader("Content-Type");
        String contentLocation = req.getHeader("Content-Location");
        InputStream inputStream = req.getInputStream();
        Message requestMessage = new Message((Object)inputStream, false, contentType, contentLocation);
        messageContext.setRequestMessage(requestMessage);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, (Object)req.getURI().getPath());
        messageContext.setProperty("transport.url", (Object)req.getURI().toString());
        messageContext.setService(this.service);
        messageContext.setProperty(REQUEST, (Object)req);
        messageContext.setProperty(RESPONSE, (Object)res);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                SOAPEnvelope env;
                String characterEncoding = (String)requestMessage.getProperty("javax.xml.soap.character-set-encoding");
                if (characterEncoding != null) {
                    messageContext.setProperty("javax.xml.soap.character-set-encoding", (Object)characterEncoding);
                } else {
                    messageContext.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
                }
                String soapAction = req.getHeader("SOAPAction");
                if (soapAction != null) {
                    messageContext.setUseSOAPAction(true);
                    messageContext.setSOAPActionURI(soapAction);
                }
                if ((env = requestMessage.getSOAPEnvelope()) != null && env.getSOAPConstants() != null) {
                    messageContext.setSOAPConstants(env.getSOAPConstants());
                }
                SOAPService service = messageContext.getService();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                service.invoke(messageContext);
                responseMessage = messageContext.getResponseMessage();
            }
            catch (AxisFault fault) {
                responseMessage = this.handleFault(fault, res, messageContext);
            }
            catch (Exception e) {
                responseMessage = this.handleException(messageContext, res, e);
            }
            if (messageContext.getOperation() != null) {
                if (messageContext.getOperation().getMep() == OperationType.ONE_WAY) {
                    res.setStatusCode(202);
                    return;
                }
                if (responseMessage == null) {
                    responseMessage = this.handleException(messageContext, null, new RuntimeException("No response for non-one-way operation"));
                }
            } else if (responseMessage == null) {
                res.setStatusCode(202);
                return;
            }
            try {
                SOAPConstants soapConstants = messageContext.getSOAPConstants();
                String contentType1 = responseMessage.getContentType(soapConstants);
                res.setContentType(contentType1);
                MimeHeaders responseMimeHeaders = responseMessage.getMimeHeaders();
                Iterator i = responseMimeHeaders.getAllHeaders();
                while (i.hasNext()) {
                    MimeHeader responseMimeHeader = (MimeHeader)i.next();
                    res.setHeader(responseMimeHeader.getName(), responseMimeHeader.getValue());
                }
                contentType = responseMessage.getContentType(messageContext.getSOAPConstants());
                responseMessage.writeTo(res.getOutputStream());
            }
            catch (Exception e) {
                log.warn((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private Message handleException(MessageContext context, WebServiceContainer.Response res, Exception e) {
        Message responseMessage = context.getResponseMessage();
        res.setStatusCode(500);
        Message responseMsg = responseMessage;
        log.warn((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
        if (responseMsg == null) {
            AxisFault fault = AxisFault.makeFault((Exception)e);
            Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
            if (runtimeException != null) {
                log.debug((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
                fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
            }
            responseMsg = new Message((Object)fault);
        }
        responseMessage = responseMsg;
        SOAPPart soapPart = (SOAPPart)responseMessage.getSOAPPart();
        soapPart.getMessage().setMessageContext(context);
        return responseMessage;
    }

    private Message handleFault(AxisFault fault, WebServiceContainer.Response res, MessageContext context) {
        int status;
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        log.warn((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
        if (runtimeException != null) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        }
        int n = status = fault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
        if (status == 401) {
            res.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        res.setStatusCode(status);
        Message responseMessage = context.getResponseMessage();
        if (responseMessage == null) {
            responseMessage = new Message((Object)fault);
            SOAPPart soapPart = (SOAPPart)responseMessage.getSOAPPart();
            soapPart.getMessage().setMessageContext(context);
        }
        return responseMessage;
    }

    public void getWsdl(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        URI realLocation = request.getURI();
        String query = realLocation.getQuery();
        if (query == null || !query.toLowerCase().startsWith("wsdl")) {
            throw new IllegalStateException("request must contain a  wsdl or WSDL parameter: " + request.getParameters());
        }
        String locationKey = query.length() > 4 ? query.substring(5) : this.wsdlLocation.toString();
        Object wsdl = this.wsdlMap.get(locationKey);
        if (wsdl == null) {
            throw new IllegalStateException("No wsdl or schema known at location: " + locationKey);
        }
        URI updated = new URI(realLocation.getScheme(), realLocation.getUserInfo(), realLocation.getHost(), realLocation.getPort(), null, null, null);
        String replaced = ((String)wsdl).replaceAll(LOCATION_REPLACEMENT_TOKEN, updated.toString());
        response.getOutputStream().write(replaced.getBytes());
        response.getOutputStream().flush();
    }

    public URI getLocation() {
        return this.location;
    }

    protected Object readResolve() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = AxisWebServiceContainer.class.getClassLoader();
        }
        return new AxisWebServiceContainer(this.location, this.wsdlLocation, this.service, this.wsdlMap, classLoader);
    }
}

