/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import net.sf.cglib.core.Signature;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.soap.SOAPConstants;

public class OperationInfo
implements Serializable {
    private final OperationDesc operationDesc;
    private final boolean useSOAPAction;
    private final String soapActionURI;
    private final SOAPConstants soapVersion;
    private final QName operationName;
    private final String methodName;
    private final String methodDesc;

    public OperationInfo(OperationDesc operationDesc, boolean useSOAPAction, String soapActionURI, SOAPConstants soapVersion, QName operationName, String methodName, String methodDesc) {
        this.operationDesc = operationDesc;
        this.useSOAPAction = useSOAPAction;
        this.soapActionURI = soapActionURI;
        this.soapVersion = soapVersion;
        this.operationName = operationName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public Signature getSignature() {
        return new Signature(this.methodName, this.methodDesc);
    }

    public OperationDesc getOperationDesc() {
        return this.operationDesc;
    }

    public boolean isUseSOAPAction() {
        return this.useSOAPAction;
    }

    public String getSoapActionURI() {
        return this.soapActionURI;
    }

    public SOAPConstants getSoapVersion() {
        return this.soapVersion;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void prepareCall(Call call) {
        call.setOperation(this.operationDesc);
        call.setUseSOAPAction(this.useSOAPAction);
        call.setSOAPActionURI(this.soapActionURI);
        call.setSOAPVersion(this.soapVersion);
        call.setOperationName(this.operationName);
        call.setOperationStyle(this.operationDesc.getStyle());
        call.setOperationUse(this.operationDesc.getUse());
    }

    public Throwable unwrapFault(RemoteException re) {
        Throwable t;
        if (re instanceof AxisFault && re.getCause() != null && this.operationDesc.getFaultByClass((t = re.getCause()).getClass()) != null) {
            return t;
        }
        return re;
    }
}

