/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.Remote;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.geronimo.axis.client.GeronimoAxisClient;
import org.apache.geronimo.axis.client.OperationInfo;
import org.apache.geronimo.axis.client.SEIFactory;

public class ServiceImpl
implements Service,
Serializable {
    private transient org.apache.axis.client.Service delegate;
    private final Map seiClassNameToFactoryMap;
    private final Map portToImplementationMap;

    public ServiceImpl(Map portToImplementationMap, Map seiClassNameToFactoryMap) {
        this.portToImplementationMap = portToImplementationMap;
        this.seiClassNameToFactoryMap = seiClassNameToFactoryMap;
        this.buildDelegateService();
    }

    private void buildDelegateService() {
        TypeMappingRegistryImpl typeMappingRegistry = new TypeMappingRegistryImpl();
        typeMappingRegistry.doRegisterFromVersion("1.3");
        SimpleProvider engineConfiguration = new SimpleProvider((org.apache.axis.encoding.TypeMappingRegistry)typeMappingRegistry);
        engineConfiguration.deployTransport("http", (Handler)new SimpleTargetedChain((Handler)new HTTPSender()));
        GeronimoAxisClient engine = new GeronimoAxisClient((EngineConfiguration)engineConfiguration, this.portToImplementationMap);
        this.delegate = new org.apache.axis.client.Service((EngineConfiguration)engineConfiguration, (AxisClient)engine);
    }

    public Remote getPort(QName qName, Class portClass) throws ServiceException {
        if (qName != null) {
            String portName = qName.getLocalPart();
            Remote port = this.internalGetPort(portName);
            return port;
        }
        return this.getPort(portClass);
    }

    public Remote getPort(Class portClass) throws ServiceException {
        String fqcn = portClass.getName();
        Remote port = this.internalGetPortFromClassName(fqcn);
        return port;
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        if (portName == null) {
            throw new ServiceException("Portname cannot be null");
        }
        SEIFactory factory = (SEIFactory)this.portToImplementationMap.get(portName.getLocalPart());
        if (factory == null) {
            throw new ServiceException("No port for portname: " + portName);
        }
        OperationInfo[] operationInfos = factory.getOperationInfos();
        Call[] array = new Call[operationInfos.length];
        for (int i = 0; i < operationInfos.length; ++i) {
            OperationInfo operation = operationInfos[i];
            array[i] = this.delegate.createCall(factory.getPortQName(), operation.getOperationName());
        }
        return array;
    }

    public Call createCall(QName qName) throws ServiceException {
        return this.delegate.createCall(qName);
    }

    public Call createCall(QName qName, QName qName1) throws ServiceException {
        return this.delegate.createCall(qName, qName1);
    }

    public Call createCall(QName qName, String s) throws ServiceException {
        return this.delegate.createCall(qName, s);
    }

    public Call createCall() throws ServiceException {
        return this.delegate.createCall();
    }

    public QName getServiceName() {
        Iterator iterator = this.portToImplementationMap.values().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        SEIFactory factory = (SEIFactory)iterator.next();
        return factory.getServiceName();
    }

    public Iterator getPorts() throws ServiceException {
        return this.portToImplementationMap.values().iterator();
    }

    public URL getWSDLDocumentLocation() {
        Iterator iterator = this.portToImplementationMap.values().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        SEIFactory factory = (SEIFactory)iterator.next();
        return factory.getWSDLDocumentLocation();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException();
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException();
    }

    Remote internalGetPort(String portName) throws ServiceException {
        if (this.portToImplementationMap.containsKey(portName)) {
            SEIFactory seiFactory = (SEIFactory)this.portToImplementationMap.get(portName);
            Remote port = seiFactory.createServiceEndpoint();
            return port;
        }
        throw new ServiceException("No port for portname: " + portName);
    }

    Remote internalGetPortFromClassName(String className) throws ServiceException {
        if (this.seiClassNameToFactoryMap.containsKey(className)) {
            SEIFactory seiFactory = (SEIFactory)this.seiClassNameToFactoryMap.get(className);
            Remote port = seiFactory.createServiceEndpoint();
            return port;
        }
        throw new ServiceException("no port for class " + className);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.buildDelegateService();
    }

    org.apache.axis.client.Service getService() {
        return this.delegate;
    }
}

