/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.Remote;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.handler.HandlerChain;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.client.Service;
import org.apache.axis.constants.Use;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.SimpleDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleSerializerFactory;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.geronimo.axis.client.GenericServiceEndpoint;
import org.apache.geronimo.axis.client.OperationInfo;
import org.apache.geronimo.axis.client.SEIFactory;
import org.apache.geronimo.axis.client.SerializableNoOp;
import org.apache.geronimo.axis.client.ServiceEndpointMethodInterceptor;
import org.apache.geronimo.axis.client.ServiceImpl;
import org.apache.geronimo.axis.client.TypeInfo;

public class SEIFactoryImpl
implements SEIFactory,
Serializable {
    private static final Class[] SERVICE_ENDPOINT_CONSTRUCTOR_TYPES = new Class[]{GenericServiceEndpoint.class};
    private final QName serviceName;
    private final QName portQName;
    private final Class serviceEndpointClass;
    private final OperationInfo[] operationInfos;
    private final transient FastConstructor constructor;
    private final Object serviceImpl;
    private final List typeInfo;
    private final URL location;
    private final List handlerInfos;
    private final String credentialsName;
    private transient HandlerInfoChainFactory handlerInfoChainFactory;
    private transient OperationInfo[] sortedOperationInfos;
    private boolean initialized = false;

    public SEIFactoryImpl(QName serviceName, String portName, Class serviceEndpointClass, OperationInfo[] operationInfos, Object serviceImpl, List typeInfo, URL location, List handlerInfos, ClassLoader classLoader, String credentialsName) throws ClassNotFoundException {
        Class[] classArray;
        this.serviceName = serviceName;
        this.portQName = new QName("", portName);
        this.serviceEndpointClass = serviceEndpointClass;
        this.operationInfos = operationInfos;
        Class[] constructorTypes = new Class[]{};
        if (classLoader == null) {
            classArray = SERVICE_ENDPOINT_CONSTRUCTOR_TYPES;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = classLoader.loadClass(GenericServiceEndpoint.class.getName());
        }
        constructorTypes = classArray;
        this.constructor = FastClass.create((Class)serviceEndpointClass).getConstructor(constructorTypes);
        this.serviceImpl = serviceImpl;
        this.typeInfo = typeInfo;
        this.location = location;
        this.handlerInfos = handlerInfos;
        this.credentialsName = credentialsName;
        this.handlerInfoChainFactory = new HandlerInfoChainFactory(handlerInfos);
        this.sortedOperationInfos = new OperationInfo[FastClass.create((Class)serviceEndpointClass).getMaxIndex() + 1];
    }

    void initialize() {
        String encodingStyle = "";
        for (int i = 0; i < this.operationInfos.length; ++i) {
            OperationInfo operationInfo = this.operationInfos[i];
            Signature signature = operationInfo.getSignature();
            MethodProxy methodProxy = MethodProxy.find((Class)this.serviceEndpointClass, (Signature)signature);
            if (methodProxy == null) {
                throw new RuntimeException("No method proxy for operationInfo " + signature);
            }
            int index = methodProxy.getSuperIndex();
            this.sortedOperationInfos[index] = operationInfo;
            if (operationInfo.getOperationDesc().getUse() != Use.ENCODED) continue;
            encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        Service service = ((ServiceImpl)this.serviceImpl).getService();
        AxisEngine axisEngine = service.getEngine();
        TypeMappingRegistry typeMappingRegistry = axisEngine.getTypeMappingRegistry();
        org.apache.axis.encoding.TypeMapping typeMapping = typeMappingRegistry.getOrMakeTypeMapping(encodingStyle);
        typeMapping.register(BigInteger.class, Constants.XSD_UNSIGNEDLONG, (SerializerFactory)new SimpleSerializerFactory(BigInteger.class, Constants.XSD_UNSIGNEDLONG), (DeserializerFactory)new SimpleDeserializerFactory(BigInteger.class, Constants.XSD_UNSIGNEDLONG));
        typeMapping.register(URI.class, Constants.XSD_ANYURI, (SerializerFactory)new SimpleSerializerFactory(URI.class, Constants.XSD_ANYURI), (DeserializerFactory)new SimpleDeserializerFactory(URI.class, Constants.XSD_ANYURI));
        Iterator iter = this.typeInfo.iterator();
        while (iter.hasNext()) {
            TypeInfo info = (TypeInfo)iter.next();
            TypeDesc.registerTypeDescForClass((Class)info.getClazz(), (TypeDesc)info.buildTypeDesc());
        }
        TypeInfo.register(this.typeInfo, (TypeMapping)typeMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote createServiceEndpoint() throws ServiceException {
        SEIFactoryImpl sEIFactoryImpl = this;
        synchronized (sEIFactoryImpl) {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
        }
        Service service = ((ServiceImpl)this.serviceImpl).getService();
        GenericServiceEndpoint serviceEndpoint = new GenericServiceEndpoint(this.portQName, service, this.location);
        ServiceEndpointMethodInterceptor callback = new ServiceEndpointMethodInterceptor(serviceEndpoint, this.sortedOperationInfos, this.credentialsName);
        Callback[] callbacks = new Callback[]{SerializableNoOp.INSTANCE, callback};
        Enhancer.registerCallbacks((Class)this.serviceEndpointClass, (Callback[])callbacks);
        try {
            return (Remote)this.constructor.newInstance(new Object[]{serviceEndpoint});
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new ServiceException("Could not construct service instance", e.getTargetException());
        }
    }

    public HandlerChain createHandlerChain() {
        HandlerChain handlerChain = this.handlerInfoChainFactory.createHandlerChain();
        return handlerChain;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            SEIFactoryImpl seiFactory = new SEIFactoryImpl(this.serviceName, this.portQName.getLocalPart(), this.serviceEndpointClass, this.operationInfos, this.serviceImpl, this.typeInfo, this.location, this.handlerInfos, null, this.credentialsName);
            return seiFactory;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidClassException(GenericServiceEndpoint.class.getName(), "this is impossible");
        }
    }

    public OperationInfo[] getOperationInfos() {
        return this.operationInfos;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public URL getWSDLDocumentLocation() {
        try {
            return new URL(this.location.toExternalForm() + "?wsdl");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

