/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.ObjectName;
import org.apache.axis.client.AdminClient;
import org.apache.axis.client.Call;
import org.apache.axis.utils.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis.AxisGeronimoConstants;
import org.apache.geronimo.axis.AxisGeronimoUtils;
import org.apache.geronimo.axis.DependancyEJBManager;
import org.apache.geronimo.axis.GeronimoWsDeployContext;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.ews.ws4j2ee.toWs.Ws4J2ee;
import org.apache.geronimo.ews.ws4j2ee.toWs.Ws4J2eeDeployContext;
import org.apache.geronimo.ews.ws4j2ee.utils.packager.load.PackageModule;
import org.apache.geronimo.j2ee.deployment.EARConfigBuilder;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.system.configuration.LocalConfigStore;
import org.apache.xmlbeans.XmlObject;
import org.openejb.deployment.OpenEJBModuleBuilder;

public class WebServiceDeployer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final String j2eeDomainName = "openejb.server";
    private static final String j2eeServerName = "TestOpenEJBServer";
    private static final ObjectName transactionManagerObjectName = JMXUtil.getObjectName((String)"openejb.server:type=TransactionManager");
    private static final ObjectName connectionTrackerObjectName = JMXUtil.getObjectName((String)"openejb.server:type=ConnectionTracker");
    private String j2eeModuleName;
    private String module;
    private final Kernel kernel;
    private Properties axisProperties;
    private String outDir;
    private Properties properites;
    private final File configStore;
    private String tempOutDir;
    private boolean hasEJB = false;
    private File axisPopertiesfile;

    public WebServiceDeployer(String tempOutDir, Kernel kernel) {
        this.tempOutDir = tempOutDir;
        this.kernel = kernel;
        this.axisProperties = new Properties();
        this.properites = new Properties();
        this.log.info((Object)"start deployer with the target/config-store as the config store.");
        this.configStore = new File("target/config-store");
    }

    public void deploy(String module, String j2eeApplicationName, String j2eeModuleName) throws Exception {
        this.j2eeModuleName = j2eeModuleName;
        this.module = module;
        this.log.info((Object)("start deploymwnt with the " + this.module + "."));
        GeronimoWsDeployContext deployContext = new GeronimoWsDeployContext(module, this.tempOutDir + "/server");
        Ws4J2ee ws4j2ee = new Ws4J2ee((Ws4J2eeDeployContext)deployContext, null);
        ws4j2ee.generate();
        this.log.info((Object)"ews code generation done.");
        PackageModule packageModule = deployContext.getModule();
        if (packageModule.getEjbJarfile() != null) {
            this.hasEJB = true;
            System.out.println("the web service is based on a ejb.");
        } else if (packageModule.getWebddfile() != null) {
            this.hasEJB = false;
            System.out.println("the web service is based on a java class.");
        } else {
            throw new DeploymentException("the module must have web.xml or ejb-jar.xml file");
        }
        File file = this.findTheImpl();
        this.deployTheWebService(file);
    }

    public void deployEWSModule(String module, String j2eeApplicationName, String j2eeModuleName) throws Exception {
        this.j2eeModuleName = j2eeModuleName;
        this.module = module;
        this.log.info((Object)("start deployment with the " + this.module + "."));
        ZipFile zipfile = new ZipFile(module);
        Enumeration<? extends ZipEntry> entires = zipfile.entries();
        while (entires.hasMoreElements()) {
            ZipEntry zipe = entires.nextElement();
            String name = zipe.getName();
            if (!name.endsWith("/ejb-jar.xml")) continue;
            this.hasEJB = true;
            System.out.println("entry found " + name + " the web service is based on a ejb.");
            break;
        }
        File file = new File(module);
        this.deployTheWebService(file);
    }

    public void loadPropertyFiles() throws FileNotFoundException, IOException {
        File popertiesfile = new File(this.configStore, "index.properties");
        int index = 1;
        if (popertiesfile.exists()) {
            this.properites.load(new FileInputStream(popertiesfile));
            while (this.properites.containsValue(String.valueOf(index))) {
                ++index;
            }
        } else {
            popertiesfile.getParentFile().mkdirs();
            popertiesfile.createNewFile();
        }
        this.outDir = String.valueOf(index);
        this.axisPopertiesfile = new File(this.configStore, this.outDir + "/axis.properties");
        this.axisPopertiesfile.getParentFile().mkdirs();
        this.axisPopertiesfile.createNewFile();
    }

    public void storeProperties() throws FileNotFoundException, IOException {
        File popertiesfile = new File(this.configStore, "index.properties");
        this.properites.store(new FileOutputStream(popertiesfile), "ws configuration");
        this.axisProperties.store(new FileOutputStream(this.axisPopertiesfile), "ws configuration");
    }

    public void deployTheWebService(File module) throws DeploymentException {
        File unpackedDir = null;
        try {
            ClassLoader parentClassLoder = ClassUtils.getDefaultClassLoader();
            ClassLoader classloader = new URLClassLoader(new URL[]{module.toURL()}, parentClassLoder);
            this.loadPropertyFiles();
            this.properites.setProperty(this.j2eeModuleName, this.outDir);
            this.axisProperties.setProperty(this.outDir, this.j2eeModuleName);
            unpackedDir = new File(this.configStore, this.outDir);
            unpackedDir.mkdirs();
            if (this.hasEJB) {
                classloader = this.deployEJB(module, unpackedDir, classloader);
                this.axisProperties.setProperty("style", "ejb");
            } else {
                File out = new File(unpackedDir, module.getName());
                this.copyTheFile(module, out);
                this.axisProperties.setProperty("style", "web");
            }
            ArrayList classList = AxisGeronimoUtils.getClassFileList(new ZipFile(module));
            for (int i = 0; i < classList.size(); ++i) {
                String className = (String)classList.get(i);
                System.out.println(className);
                ClassUtils.setClassLoader((String)className, (ClassLoader)classloader);
            }
            System.out.println("Calss Utils class lader set at deployment =" + classloader);
            this.addEntryToAxisDD(module);
        }
        catch (Exception e) {
            if (unpackedDir != null) {
                AxisGeronimoUtils.delete(unpackedDir);
            }
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader deployEJB(File earFile, File unpackedDir, ClassLoader cl) throws DeploymentException {
        ClassLoader classLoader;
        OpenEJBModuleBuilder moduleBuilder = new OpenEJBModuleBuilder(this.kernel);
        Thread.currentThread().setContextClassLoader(cl);
        File carFile = File.createTempFile("OpenEJBTest", ".car");
        ObjectName j2eeServerObjectName = ObjectName.getInstance("openejb.server:j2eeType=J2EEServer,name=TestOpenEJBServer");
        try {
            EARConfigBuilder earConfigBuilder = new EARConfigBuilder(j2eeServerObjectName, AxisGeronimoConstants.TRANSACTIONCONTEXTMANAGER_NAME, AxisGeronimoConstants.TRACKEDCONNECTIONASSOCIATOR_NAME, AxisGeronimoConstants.TRANSACTIONALTIMER_NAME, AxisGeronimoConstants.NONTRANSACTIONALTIMER_NAME, null, (ModuleBuilder)moduleBuilder, (EJBReferenceBuilder)moduleBuilder, null, null, null);
            XmlObject plan = earConfigBuilder.getDeploymentPlan(earFile.toURL());
            earConfigBuilder.buildConfiguration(carFile, null, earFile, plan);
            LocalConfigStore.unpack((File)unpackedDir, (InputStream)new FileInputStream(carFile));
            this.storeProperties();
            ObjectName serviceobjectName = ObjectName.getInstance("test:configuration=" + this.j2eeModuleName);
            classLoader = DependancyEJBManager.startDependancy(unpackedDir, serviceobjectName, this.configStore, this.kernel);
            carFile.delete();
        }
        catch (Throwable throwable) {
            try {
                carFile.delete();
                throw throwable;
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        return classLoader;
    }

    private File findTheImpl() {
        File[] files;
        File outDir = new File(this.tempOutDir + "/server");
        if (outDir.isDirectory() && (files = outDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().endsWith(".jar")) continue;
                return files[i];
            }
        }
        throw new RuntimeException("implementation jar not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTheFile(File inFile, File outFile) throws IOException {
        FileOutputStream out = new FileOutputStream(outFile);
        FileInputStream in = new FileInputStream(inFile);
        try {
            byte[] buf = new byte[1024];
            int val = in.read(buf);
            while (val > 0) {
                out.write(buf, 0, val);
                val = in.read(buf);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private void addEntryToAxisDD(File module) throws DeploymentException {
        try {
            ZipFile jarmodule = new ZipFile(module);
            ZipEntry deployentry = jarmodule.getEntry("deploy.wsdd");
            if (deployentry == null) {
                throw new DeploymentException("the deploy.wsdd can not be found");
            }
            InputStream deplydd = jarmodule.getInputStream(deployentry);
            AdminClient adminClient = new AdminClient();
            URL requestUrl = new URL("http://localhost:5678/axis/services/AdminService");
            Call call = adminClient.getCall();
            call.setTargetEndpointAddress(requestUrl);
            String result = adminClient.process(null, deplydd);
            System.out.println(result);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException((Throwable)e);
        }
    }
}

