/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.axis.utils.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis.AxisGeronimoUtils;
import org.apache.geronimo.axis.DependancyEJBManager;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.jetty.JettyWebAppContext;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.transaction.UserTransactionImpl;

public class WebServiceContainer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Kernel kernel;
    private ObjectName containerName;
    private MBeanServer mbServer;
    private Set containerPatterns;
    private ObjectName tmName;
    private ObjectName tcaName;
    private ObjectName appName;
    private DependancyEJBManager ejbManager;
    private ObjectName tcmName;

    public WebServiceContainer(Kernel kernel) {
        try {
            this.kernel = kernel;
            this.mbServer = kernel.getMBeanServer();
            this.containerName = new ObjectName("geronimo.jetty:role=Container");
            this.containerPatterns = Collections.singleton(this.containerName);
            this.appName = new ObjectName("geronimo.jetty:app=test");
            this.tmName = new ObjectName("geronimo.test:role=TransactionManager");
            this.tcmName = new ObjectName("geronimo.test:role=TransactionContextManager");
            this.tcaName = new ObjectName("geronimo.test:role=ConnectionTrackingCoordinator");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public void init() {
    }

    public void doStart() throws Exception {
        this.ejbManager = new DependancyEJBManager(this.kernel);
        ClassUtils.setDefaultClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
        this.loadDeployedWebservices();
        GBeanMBean app = new GBeanMBean(JettyWebAppContext.GBEAN_INFO);
        URL url = Thread.currentThread().getContextClassLoader().getResource("deployables/axis/");
        app.setAttribute("uri", (Object)URI.create(url.toString()));
        app.setAttribute("contextPath", (Object)"/axis");
        app.setAttribute("componentContext", null);
        UserTransactionImpl userTransaction = new UserTransactionImpl();
        app.setAttribute("userTransaction", (Object)userTransaction);
        app.setReferencePatterns("Configuration", Collections.EMPTY_SET);
        app.setReferencePatterns("JettyContainer", this.containerPatterns);
        app.setReferencePattern("TransactionContextManager", this.tcmName);
        app.setReferencePattern("TrackedConnectionAssociator", this.tcaName);
        this.start(this.appName, app);
        this.log.debug((Object)"Axis started as a web application inside Jetty");
    }

    public void doStop() throws Exception {
    }

    private void start(ObjectName name, Object instance) throws Exception {
        this.mbServer.registerMBean(instance, name);
        this.mbServer.invoke(name, "start", null, null);
    }

    private void stop(ObjectName name) throws Exception {
        this.mbServer.invoke(name, "stop", null, null);
        this.mbServer.unregisterMBean(name);
    }

    public void loadDeployedWebservices() throws MalformedURLException, DeploymentException {
        try {
            File configStroe = new File("target/config-store");
            File[] apps = configStroe.listFiles();
            if (apps != null) {
                for (int i = 0; i < apps.length; ++i) {
                    ClassLoader classloader;
                    File f = new File(apps[i], "axis.properties");
                    if (!f.exists()) continue;
                    Properties p = new Properties();
                    FileInputStream in = new FileInputStream(f);
                    p.load(in);
                    in.close();
                    String dir = f.getName();
                    String serviceName = (String)p.get(dir);
                    String style = (String)p.get("style");
                    File module = null;
                    File[] jars = f.listFiles();
                    if (jars != null) {
                        for (int j = 0; j < jars.length; ++j) {
                            if (!jars[i].getAbsolutePath().endsWith(".jar")) continue;
                            module = jars[i];
                            this.log.debug((Object)("found a jar" + jars[i].getAbsolutePath()));
                            break;
                        }
                    }
                    if ("ejb".equals(style)) {
                        ObjectName serviceobjectName = ObjectName.getInstance("test:configuration=" + serviceName);
                        classloader = DependancyEJBManager.startDependancy(apps[i], serviceobjectName, configStroe, this.kernel);
                    } else {
                        classloader = new URLClassLoader(new URL[]{module.toURL()});
                    }
                    ArrayList classList = AxisGeronimoUtils.getClassFileList(new ZipFile(module));
                    for (int j = 0; j < classList.size(); ++j) {
                        String className = (String)classList.get(i);
                        System.out.println(className);
                        ClassUtils.setClassLoader((String)className, (ClassLoader)classloader);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

