/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.assembly;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.system.repository.FileSystemRepository;

public class BaseConfigInstaller {
    protected File targetRoot;
    protected String targetConfigStore;
    protected String targetRepository;
    private String artifact;
    private File sourceRepository;
    protected URI sourceRepositoryURI;

    public File getTargetRoot() {
        return this.targetRoot;
    }

    public void setTargetRoot(File targetRoot) {
        this.targetRoot = targetRoot;
    }

    public String getTargetConfigStore() {
        return this.targetConfigStore;
    }

    public void setTargetConfigStore(String targetConfigStore) {
        this.targetConfigStore = targetConfigStore;
    }

    public String getTargetRepository() {
        return this.targetRepository;
    }

    public void setTargetRepository(String targetRepository) {
        this.targetRepository = targetRepository;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public File getSourceRepository() {
        return this.sourceRepository;
    }

    public void setSourceRepository(File sourceRepository) {
        this.sourceRepository = sourceRepository;
        this.sourceRepositoryURI = sourceRepository.toURI();
    }

    public URI getSourceRepositoryURI() {
        return this.sourceRepositoryURI;
    }

    public void setSourceRepositoryURI(URI sourceRepositoryURI) {
        this.sourceRepositoryURI = sourceRepositoryURI;
    }

    protected void execute(InstallAdapter installAdapter, Repository sourceRepo, FileSystemRepository targetRepo) throws IOException, InvalidConfigException {
        URI configId = URI.create(this.artifact);
        this.execute(configId, installAdapter, sourceRepo, targetRepo);
    }

    protected void execute(URI configId, InstallAdapter installAdapter, Repository sourceRepo, FileSystemRepository targetRepo) throws IOException, InvalidConfigException {
        if (installAdapter.containsConfiguration(configId)) {
            System.out.println("Configuration " + configId + " already present in configuration store");
            return;
        }
        GBeanData config = installAdapter.install(sourceRepo, configId);
        List dependencies = (List)config.getAttribute("dependencies");
        System.out.println("Installed configuration " + configId);
        StartFileWriteMonitor monitor = new StartFileWriteMonitor();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            URI dependency = (URI)iterator.next();
            if (!sourceRepo.hasURI(dependency)) {
                throw new RuntimeException("Dependency: " + dependency + " not found in local maven repo: for configuration: " + this.artifact);
            }
            if (targetRepo.hasURI(dependency)) continue;
            URL sourceURL = sourceRepo.getURL(dependency);
            InputStream in = sourceURL.openStream();
            targetRepo.copyToRepository(in, dependency, (FileWriteMonitor)monitor);
        }
        URI[] parentId = (URI[])config.getAttribute("parentId");
        if (parentId != null) {
            for (int i = 0; i < parentId.length; ++i) {
                URI parent = parentId[i];
                this.execute(parent, installAdapter, sourceRepo, targetRepo);
            }
        }
    }

    protected class InnerRepository
    implements Repository {
        protected InnerRepository() {
        }

        public boolean hasURI(URI uri) {
            if ("file".equals((uri = this.resolve(uri)).getScheme())) {
                return new File(uri).canRead();
            }
            try {
                uri.toURL().openStream().close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        public URL getURL(URI uri) throws MalformedURLException {
            uri = this.resolve(uri);
            return uri.toURL();
        }

        private URI resolve(URI uri) {
            String[] bits = uri.toString().split("/");
            StringBuffer buf = new StringBuffer(bits[0]).append('/');
            String type = bits.length >= 4 ? bits[3] : "jar";
            buf.append(type).append('s').append('/').append(bits[1]).append('-').append(bits[2]).append('.').append(type);
            return BaseConfigInstaller.this.sourceRepositoryURI.resolve(buf.toString());
        }
    }

    protected static class StartFileWriteMonitor
    implements FileWriteMonitor {
        protected StartFileWriteMonitor() {
        }

        public void writeStarted(String fileDescription) {
            System.out.println("Copying " + fileDescription);
        }

        public void writeProgress(int bytes) {
        }

        public void writeComplete(int bytes) {
        }
    }

    protected static interface InstallAdapter {
        public GBeanData install(Repository var1, URI var2) throws IOException, InvalidConfigException;

        public boolean containsConfiguration(URI var1);
    }
}

