/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.xslt;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.xslt.XSLTService;
import org.apache.fulcrum.xslt.XSLTServiceFacade;
import org.w3c.dom.Node;

public class DefaultXSLTService
extends AbstractLogEnabled
implements XSLTService,
Initializable,
Configurable,
Contextualizable,
Serviceable {
    private String applicationRoot;
    protected boolean caching = false;
    protected String path;
    private String styleSheetPath;
    protected Hashtable cache = new Hashtable();
    protected static final String STYLESHEET_PATH = "path";
    protected static final String STYLESHEET_CACHING = "cache";
    private static TransformerFactory tfactory;

    protected String getFileName(String templateName) {
        File f;
        int colon = templateName.lastIndexOf(".");
        if (colon > 0) {
            templateName = templateName.substring(0, colon);
        }
        if ((f = new File(this.path + templateName + ".xsl")).exists()) {
            return this.path + templateName + ".xsl";
        }
        f = new File(this.path + "default.xsl");
        if (f.exists()) {
            return this.path + "default.xsl";
        }
        return null;
    }

    protected Templates compileTemplates(String source) throws Exception {
        StreamSource xslin = new StreamSource(new File(source));
        Templates root = tfactory.newTemplates(xslin);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String xslName) throws Exception {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            String fn = this.getFileName(xslName);
            if (fn == null) {
                return null;
            }
            if (this.caching && this.cache.containsKey(fn)) {
                return (Templates)this.cache.get(fn);
            }
            Templates sr = this.compileTemplates(fn);
            if (this.caching) {
                this.cache.put(fn, sr);
            }
            return sr;
        }
    }

    protected void transform(String xslName, Source xmlin, Result xmlout) throws Exception {
        Transformer transformer = this.getTransformer(xslName);
        transformer.transform(xmlin, xmlout);
    }

    public void transform(String xslName, Reader in, Writer out) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout);
    }

    public String transform(String xslName, Reader in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout);
    }

    public String transform(String xslName, Node in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public Transformer getTransformer(String xslName) throws Exception {
        Templates sr = this.getTemplates(xslName);
        if (sr == null) {
            return tfactory.newTransformer();
        }
        return sr.newTransformer();
    }

    public String getRealPath(String path) {
        String absolutePath = null;
        absolutePath = this.applicationRoot == null ? new File(path).getAbsolutePath() : new File(this.applicationRoot, path).getAbsolutePath();
        return absolutePath;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.styleSheetPath = conf.getAttribute(STYLESHEET_PATH);
        this.caching = conf.getAttributeAsBoolean(STYLESHEET_CACHING);
    }

    public void initialize() throws Exception {
        this.path = this.getRealPath(this.styleSheetPath);
        if (!this.path.endsWith("/") && !this.path.endsWith("\\")) {
            this.path = this.path + File.separator;
        }
        tfactory = TransformerFactory.newInstance();
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }

    public void service(ServiceManager manager) {
        XSLTServiceFacade.setService(this);
    }

    public void dispose() {
    }
}

