/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory.basic;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.basic.BasicModelManager;
import org.apache.fulcrum.security.model.basic.entity.BasicGroup;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryModelManagerImpl
extends AbstractManager
implements BasicModelManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fulcrum$security$memory$basic$MemoryModelManagerImpl == null ? (class$org$apache$fulcrum$security$memory$basic$MemoryModelManagerImpl = MemoryModelManagerImpl.class$("org.apache.fulcrum.security.memory.basic.MemoryModelManagerImpl")) : class$org$apache$fulcrum$security$memory$basic$MemoryModelManagerImpl));
    static /* synthetic */ Class class$org$apache$fulcrum$security$memory$basic$MemoryModelManagerImpl;

    public void grant(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean userExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            userExists = this.getUserManager().checkExists(user);
            if (groupExists && userExists) {
                ((BasicUser)user).addGroup(group);
                ((BasicGroup)group).addUser(user);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public void revoke(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean userExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            userExists = this.getUserManager().checkExists(user);
            if (groupExists && userExists) {
                ((BasicUser)user).removeGroup(group);
                ((BasicGroup)group).removeUser(user);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        try {
            userExists = this.getUserManager().checkExists(user);
            if (userExists) {
                Iterator i = ((BasicUser)user).getGroups().iterator();
                while (i.hasNext()) {
                    BasicGroup group = (BasicGroup)i.next();
                    group.removeUser(user);
                }
                ((BasicUser)user).setGroups(new GroupSet());
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revokeAll(User) failed:" + e.getMessage(), (Throwable)e);
        }
        throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

