/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractRoleManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryRoleManagerImpl
extends AbstractRoleManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fulcrum$security$memory$MemoryRoleManagerImpl == null ? (class$org$apache$fulcrum$security$memory$MemoryRoleManagerImpl = MemoryRoleManagerImpl.class$("org.apache.fulcrum.security.memory.MemoryRoleManagerImpl")) : class$org$apache$fulcrum$security$memory$MemoryRoleManagerImpl));
    private static List roles = new ArrayList();
    private static int uniqueId = 0;
    static /* synthetic */ Class class$org$apache$fulcrum$security$memory$MemoryRoleManagerImpl;

    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                roles.remove(role);
                role.setName(name);
                roles.add(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("renameRole(Role,String)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public boolean checkExists(String roleName) {
        return MemoryHelper.checkExists(roles, roleName);
    }

    public RoleSet getAllRoles() throws DataBackendException {
        return new RoleSet((Collection)roles);
    }

    protected synchronized Role persistNewRole(Role role) throws DataBackendException {
        role.setId((Object)MemoryHelper.getUniqueId());
        roles.add(role);
        this.getAllRoles().add(role);
        return role;
    }

    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                roles.remove(role);
                this.getAllRoles().remove(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("removeRole(Role)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

