/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractPermissionManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryPermissionManagerImpl
extends AbstractPermissionManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fulcrum$security$memory$MemoryPermissionManagerImpl == null ? (class$org$apache$fulcrum$security$memory$MemoryPermissionManagerImpl = MemoryPermissionManagerImpl.class$("org.apache.fulcrum.security.memory.MemoryPermissionManagerImpl")) : class$org$apache$fulcrum$security$memory$MemoryPermissionManagerImpl));
    private static List permissions = new ArrayList();
    private static int uniqueId = 0;
    static /* synthetic */ Class class$org$apache$fulcrum$security$memory$MemoryPermissionManagerImpl;

    public PermissionSet getAllPermissions() throws DataBackendException {
        return new PermissionSet((Collection)permissions);
    }

    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                permissions.remove(permission);
                permission.setName(name);
                permissions.add(permission);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("renamePermission(Permission,name)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public boolean checkExists(String permissionName) throws DataBackendException {
        return MemoryHelper.checkExists(permissions, permissionName);
    }

    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (!permissionExists) {
                throw new UnknownEntityException("Unknown permission '" + permission + "'");
            }
            permissions.remove(permission);
        }
        catch (Exception e) {
            throw new DataBackendException("removePermission(Permission)", (Throwable)e);
        }
    }

    protected synchronized Permission persistNewPermission(Permission permission) throws DataBackendException {
        permission.setId((Object)MemoryHelper.getUniqueId());
        permissions.add(permission);
        return permission;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

