/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractGroupManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryGroupManagerImpl
extends AbstractGroupManager
implements GroupManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fulcrum$security$memory$MemoryGroupManagerImpl == null ? (class$org$apache$fulcrum$security$memory$MemoryGroupManagerImpl = MemoryGroupManagerImpl.class$("org.apache.fulcrum.security.memory.MemoryGroupManagerImpl")) : class$org$apache$fulcrum$security$memory$MemoryGroupManagerImpl));
    private static List groups = new ArrayList();
    private static int uniqueId = 0;
    static /* synthetic */ Class class$org$apache$fulcrum$security$memory$MemoryGroupManagerImpl;

    public GroupSet getAllGroups() throws DataBackendException {
        return new GroupSet((Collection)groups);
    }

    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (groupExists) {
                groups.remove(group);
                return;
            }
            throw new UnknownEntityException("Unknown group '" + group + "'");
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete a Group");
            log.error((Object)e);
            throw new DataBackendException("removeGroup(Group) failed", (Throwable)e);
        }
    }

    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (!groupExists) {
                throw new UnknownEntityException("Unknown group '" + group + "'");
            }
            groups.remove(group);
            group.setName(name);
            groups.add(group);
        }
        catch (Exception e) {
            throw new DataBackendException("renameGroup(Group,String)", (Throwable)e);
        }
    }

    public boolean checkExists(String groupName) throws DataBackendException {
        return MemoryHelper.checkExists(groups, groupName);
    }

    public synchronized Group persistNewGroup(Group group) throws DataBackendException {
        group.setId((Object)MemoryHelper.getUniqueId());
        groups.add(group);
        return group;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

