/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fulcrum.mimetype.util.MimeType;
import org.apache.fulcrum.mimetype.util.MimeTypeMapper;

public class MimeTypeMap {
    public static final MimeType DEFAULT_MIMETYPE = MimeType.APPLICATION_OCTET_STREAM;
    public static final String DEFAULT_TYPE = DEFAULT_MIMETYPE.toString();
    public static final String MIMETYPE_RESOURCE = "mime.types";
    public static final String EXT_HTML = "html";
    public static final String EXT_HTM = "htm";
    public static final String EXT_WML = "wml";
    public static final String EXT_HDML = "hdml";
    public static final String EXT_HDM = "hdm";
    public static final String EXT_CHTML = "chtml";
    public static final String EXT_TEXT = "txt";
    public static final String EXT_GIF = "gif";
    public static final String EXT_JPEG = "jpeg";
    public static final String EXT_JPG = "jpg";
    public static final String EXT_WBMP = "wbmp";
    private static final int MAP_PROG = 0;
    private static final int MAP_HOME = 1;
    private static final int MAP_SYS = 2;
    private static final int MAP_JAR = 3;
    private static final int MAP_COM = 4;
    private static MimeTypeMapper commonMapper = new MimeTypeMapper();
    private MimeTypeMapper[] mappers = new MimeTypeMapper[5];
    static /* synthetic */ Class class$org$apache$fulcrum$mimetype$util$MimeTypeMap;

    protected static MimeTypeMapper loadPath(String path) throws IOException {
        return new MimeTypeMapper(path);
    }

    protected static MimeTypeMapper loadResource(String name) {
        InputStream input = (class$org$apache$fulcrum$mimetype$util$MimeTypeMap == null ? (class$org$apache$fulcrum$mimetype$util$MimeTypeMap = MimeTypeMap.class$("org.apache.fulcrum.mimetype.util.MimeTypeMap")) : class$org$apache$fulcrum$mimetype$util$MimeTypeMap).getResourceAsStream(name);
        if (input != null) {
            try {
                return new MimeTypeMapper(input);
            }
            catch (IOException x) {
                return null;
            }
        }
        return null;
    }

    public MimeTypeMap() {
        String path;
        try {
            path = System.getProperty("user.home");
            if (path != null) {
                path = path + File.separator + MIMETYPE_RESOURCE;
                this.mappers[1] = MimeTypeMap.loadPath(path);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            path = System.getProperty("java.home") + File.separator + "lib" + File.separator + MIMETYPE_RESOURCE;
            this.mappers[2] = MimeTypeMap.loadPath(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mappers[3] = MimeTypeMap.loadResource("/META-INF/mime.types");
        this.mappers[4] = commonMapper;
    }

    public MimeTypeMap(InputStream input) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(input);
    }

    public MimeTypeMap(File file) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(file);
    }

    public MimeTypeMap(String path) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(path);
    }

    public synchronized void setContentType(String spec) {
        if (this.mappers[0] == null) {
            this.mappers[0] = new MimeTypeMapper();
        }
        this.mappers[0].setContentType(spec);
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public String getContentType(String fileName) {
        return this.getContentType(fileName, DEFAULT_TYPE);
    }

    public String getContentType(String fileName, String def) {
        String ext = MimeTypeMap.parseFileExtension(fileName);
        if (ext != null) {
            for (int i = 0; i < this.mappers.length; ++i) {
                String mimeType;
                MimeTypeMapper mapper = this.mappers[i];
                if (mapper == null || (mimeType = mapper.getContentType(ext)) == null) continue;
                return mimeType;
            }
        }
        return def;
    }

    private static String parseFileExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        return i >= 0 && i + 2 < fileName.length() ? fileName.substring(i + 1) : null;
    }

    public MimeType getMimeContentType(File file) {
        try {
            return new MimeType(this.getContentType(file));
        }
        catch (Exception x) {
            return DEFAULT_MIMETYPE;
        }
    }

    public MimeType getMimeContentType(String name) {
        try {
            return new MimeType(this.getContentType(name));
        }
        catch (Exception x) {
            return DEFAULT_MIMETYPE;
        }
    }

    public MimeType getMimeContentType(String ext, String def) {
        try {
            return new MimeType(this.getContentType(ext, def));
        }
        catch (Exception x) {
            return DEFAULT_MIMETYPE;
        }
    }

    public String getDefaultExtension(String type) {
        int i = type.indexOf(59);
        if (i >= 0) {
            type = type.substring(0, i);
        }
        type = type.trim();
        for (i = this.mappers.length - 1; i >= 0; --i) {
            String ext;
            MimeTypeMapper mapper = this.mappers[i];
            if (mapper == null || (ext = mapper.getExtension(type)) == null) continue;
            return ext;
        }
        return null;
    }

    public String getDefaultExtension(MimeType mime) {
        return this.getDefaultExtension(mime.getTypes());
    }

    protected synchronized void setCommonContentType(String spec) {
        this.mappers[4].setContentType(spec);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        commonMapper.setContentType(MimeType.TEXT_HTML.toString() + " " + EXT_HTML + " " + EXT_HTM);
        commonMapper.setContentType(MimeType.TEXT_WML.toString() + " " + EXT_WML);
        commonMapper.setContentType(MimeType.TEXT_HDML.toString() + " " + EXT_HDML + " " + EXT_HDM);
        commonMapper.setContentType(MimeType.TEXT_CHTML.toString() + " " + EXT_CHTML);
        commonMapper.setContentType(MimeType.TEXT_PLAIN.toString() + " " + EXT_TEXT);
        commonMapper.setContentType(MimeType.IMAGE_GIF.toString() + " " + EXT_GIF);
        commonMapper.setContentType(MimeType.IMAGE_JPEG.toString() + " " + EXT_JPEG + " " + EXT_JPG);
        commonMapper.setContentType(MimeType.IMAGE_WBMP.toString() + " " + EXT_WBMP);
    }
}

