/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.mimetype.MimeTypeService;
import org.apache.fulcrum.mimetype.util.CharSetMap;
import org.apache.fulcrum.mimetype.util.MimeType;
import org.apache.fulcrum.mimetype.util.MimeTypeMap;

public class DefaultMimeTypeService
extends AbstractLogEnabled
implements MimeTypeService,
Configurable,
Initializable,
Contextualizable {
    private String applicationRoot;
    public static final String MIME_TYPES = "mimetypes";
    public static final String CHARSETS = "charsets";
    private String mimetypePath;
    private String charsetPath;
    private MimeTypeMap mimeTypeMap;
    private CharSetMap charSetMap;
    private Context context = null;

    public void setContentType(String spec) {
        this.mimeTypeMap.setContentType(spec);
    }

    public String getContentType(File file) {
        return this.mimeTypeMap.getContentType(file);
    }

    public String getContentType(String fileName) {
        return this.mimeTypeMap.getContentType(fileName);
    }

    public String getContentType(String fileName, String def) {
        return this.mimeTypeMap.getContentType(fileName, def);
    }

    public MimeType getMimeContentType(File file) {
        return this.mimeTypeMap.getMimeContentType(file);
    }

    public MimeType getMimeContentType(String name) {
        return this.mimeTypeMap.getMimeContentType(name);
    }

    public MimeType getMimeContentType(String ext, String def) {
        return this.mimeTypeMap.getMimeContentType(ext, def);
    }

    public String getDefaultExtension(String type) {
        return this.mimeTypeMap.getDefaultExtension(type);
    }

    public String getDefaultExtension(MimeType mime) {
        return this.mimeTypeMap.getDefaultExtension(mime);
    }

    public void setCharSet(String key, String charset) {
        this.charSetMap.setCharSet(key, charset);
    }

    public String getCharSet(Locale locale) {
        return this.charSetMap.getCharSet(locale);
    }

    public String getCharSet(Locale locale, String variant) {
        return this.charSetMap.getCharSet(locale, variant);
    }

    public String getCharSet(String key) {
        return this.charSetMap.getCharSet(key);
    }

    public String getCharSet(String key, String def) {
        return this.charSetMap.getCharSet(key, def);
    }

    private String getRealPath(String path) {
        String absolutePath = null;
        absolutePath = this.applicationRoot == null ? new File(path).getAbsolutePath() : new File(this.applicationRoot, path).getAbsolutePath();
        return absolutePath;
    }

    public void configure(Configuration conf) {
        this.mimetypePath = conf.getAttribute(MIME_TYPES, null);
        this.charsetPath = conf.getAttribute(CHARSETS, null);
        if (this.mimetypePath != null) {
            this.mimetypePath = this.getRealPath(this.mimetypePath);
        }
        if (this.charsetPath != null) {
            this.charsetPath = this.getRealPath(this.charsetPath);
        }
    }

    public void initialize() throws Exception {
        if (this.mimetypePath != null) {
            try {
                this.mimeTypeMap = new MimeTypeMap(this.mimetypePath);
            }
            catch (IOException x) {
                throw new Exception(this.mimetypePath, x);
            }
        } else {
            this.mimeTypeMap = new MimeTypeMap();
        }
        if (this.charsetPath != null) {
            try {
                this.charSetMap = new CharSetMap(this.charsetPath);
            }
            catch (IOException x) {
                throw new Exception(this.charsetPath, x);
            }
        } else {
            this.charSetMap = new CharSetMap();
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }
}

