/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import foundation.stack.docker.Os;
import foundation.stack.docker.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInstaller {
    private static final Logger logger = LoggerFactory.getLogger(DockerInstaller.class);

    public static int installDocker(File file) throws IOException {
        if (file != null) {
            logger.debug("Launching Docker installer at {}", (Object)file);
            int result = DockerInstaller.executeInstaller(file);
            DockerInstaller.postInstallWork();
            return result;
        }
        return -1;
    }

    private static int executeInstaller(File file) throws IOException {
        int result;
        try {
            result = DockerInstaller.executeInstallerCommand(file);
        }
        catch (InterruptedException e) {
            logger.debug("Error waiting for Docker installer", (Throwable)e);
            return -1;
        }
        logger.debug("Installer command execution finished with result {}", (Object)result);
        return result;
    }

    private static void postInstallWork() throws IOException {
        if (Os.getSystemOs() == Os.Linux) {
            boolean userBelongsToDockerGroup = false;
            try {
                String groupsLine;
                String[] groups;
                List<String> output = ProcessRunner.runProcess("groups");
                if (output != null && output.size() > 0 && (groups = (groupsLine = output.get(0)).split(" ")).length > 0) {
                    for (String group : groups) {
                        if (!"docker".equalsIgnoreCase(group)) continue;
                        userBelongsToDockerGroup = true;
                    }
                }
            }
            catch (InterruptedException output) {
                // empty catch block
            }
            if (!userBelongsToDockerGroup) {
                logger.debug("Current user does not belong to docker group - trying to add the user now");
                try {
                    ProcessRunner.runProcess("sudo", "usermod", "-aG", "docker", System.getProperty("user.name"));
                }
                catch (IOException | InterruptedException e) {
                    logger.debug("Failed to add user to docker group");
                }
            }
        }
    }

    private static int executeInstallerCommand(File file) throws IOException, InterruptedException {
        switch (Os.getSystemOs()) {
            case Windows: {
                return ProcessRunner.runProcessAndGetResult(file.getAbsolutePath());
            }
            case MacOS: {
                return ProcessRunner.runProcessAndGetResult("open", "-W", file.getAbsolutePath());
            }
            case Linux: {
                return ProcessRunner.runProcessAndGetResult("sh", file.getAbsolutePath());
            }
        }
        throw new IllegalStateException("Could not figure platform when trying to run installer");
    }
}

