package foundation.stack.docker;

import com.google.common.io.CharStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @author Ravi Chodavarapu (rchodava@gmail.com)
 */
public class ProcessRunner {
    private static final Logger logger = LoggerFactory.getLogger(ProcessRunner.class);

    public static List<String> runProcess(String... command) throws IOException, InterruptedException {
        logger.debug("{}{}", "", command);

        Process process = new ProcessBuilder(command).start();

        BufferedReader processOutput = new BufferedReader(new
                InputStreamReader(process.getInputStream()));

        List<String> output = new CopyOnWriteArrayList<>();

        Thread processOutputThread = new Thread(() -> {
            try {
                String line;
                do {
                    line = processOutput.readLine();
                    if (line != null) {
                        output.add(line);
                        logger.debug("{}", line);
                    }
                } while (line != null && !Thread.interrupted());
            } catch (IOException e) {
            }
        });

        processOutputThread.start();

        if (processOutputThread != null) {
            processOutputThread.join(500);
        }

        int result = process.waitFor();

        if (result != 0) {
            return null;
        }

        return output;
    }

    public static int runProcessAndGetResult(String... command) throws IOException, InterruptedException {
        logger.debug("{}{}", "", command);

        Process process = new ProcessBuilder(command).redirectErrorStream(true).start();

        BufferedReader processOutput = new BufferedReader(new
                InputStreamReader(process.getInputStream()));

        Thread processOutputThread = null;
        if (logger.isDebugEnabled()) {
            processOutputThread = new Thread(() -> {
                try {
                    String line;
                    do {
                        line = processOutput.readLine();
                        logger.debug("{}", line);
                    } while (line != null && !Thread.interrupted());
                } catch (IOException e) {
                }
            });

            processOutputThread.start();
        }

        int result = process.waitFor();

        if (processOutputThread != null) {
            processOutputThread.join(500);
        }

        return result;
    }
}
