package foundation.stack.docker;

import java.util.Locale;

/**
 * @author Ravi Chodavarapu (rchodava@gmail.com)
 */
public enum Os {
    Windows, MacOS, Linux, Other;

    private static Os detectedOS;

    public static Os getSystemOs() {
        if (detectedOS == null) {
            String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if ((os.contains("mac")) || (os.contains("darwin"))) {
                detectedOS = Os.MacOS;
            } else if (os.contains("win")) {
                detectedOS = Os.Windows;
            } else if (os.contains("nux")) {
                detectedOS = Os.Linux;
            } else {
                detectedOS = Os.Other;
            }
        }

        return detectedOS;
    }
}
