/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner {
    private static final Logger logger = LoggerFactory.getLogger(ProcessRunner.class);

    public static List<String> runProcess(String ... command) throws IOException, InterruptedException {
        int result;
        logger.debug("{}{}", (Object)"", (Object)command);
        Process process = new ProcessBuilder(command).start();
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        CopyOnWriteArrayList<String> output = new CopyOnWriteArrayList<String>();
        Thread processOutputThread = new Thread(() -> {
            try {
                String line;
                do {
                    if ((line = processOutput.readLine()) == null) continue;
                    output.add(line);
                    logger.debug("{}", (Object)line);
                } while (line != null && !Thread.interrupted());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        processOutputThread.start();
        if (processOutputThread != null) {
            processOutputThread.join(500L);
        }
        if ((result = process.waitFor()) != 0) {
            return null;
        }
        return output;
    }

    public static int runProcessAndGetResult(String ... command) throws IOException, InterruptedException {
        logger.debug("{}{}", (Object)"", (Object)command);
        Process process = new ProcessBuilder(command).redirectErrorStream(true).start();
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Thread processOutputThread = null;
        if (logger.isDebugEnabled()) {
            processOutputThread = new Thread(() -> {
                try {
                    String line;
                    do {
                        line = processOutput.readLine();
                        logger.debug("{}", (Object)line);
                    } while (line != null && !Thread.interrupted());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            processOutputThread.start();
        }
        int result = process.waitFor();
        if (processOutputThread != null) {
            processOutputThread.join(500L);
        }
        return result;
    }
}

