/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import foundation.stack.docker.DelegatingDockerClient;
import foundation.stack.docker.DockerClient;
import foundation.stack.docker.DockerDetector;
import foundation.stack.docker.Os;
import foundation.stack.docker.ProcessRunner;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerMachineClient {
    private static final Logger logger = LoggerFactory.getLogger(DockerMachineClient.class);
    private final String machineExecutable = DockerMachineClient.getMachineExecutable();

    private static String getMachineExecutable() throws Exception {
        switch (Os.getSystemOs()) {
            case Windows: {
                return DockerDetector.getDockerInstallPathForWindows() + File.separatorChar + "docker-machine.exe";
            }
        }
        return DockerDetector.getDockerInstallPathForUnix("docker-machine");
    }

    public boolean isMachineCreated(String machine) throws Exception {
        logger.debug("Checking if Docker machine {} has been created", (Object)machine);
        List<String> result = ProcessRunner.runProcess(this.machineExecutable, "status", machine);
        return result != null && result.size() > 0 && ("Running".equals(result.get(0)) || "Stopped".equals(result.get(0)));
    }

    public boolean isMachineRunning(String machine) throws Exception {
        logger.debug("Checking if Docker machine {} is running", (Object)machine);
        List<String> result = ProcessRunner.runProcess(this.machineExecutable, "status", machine);
        return result != null && result.size() > 0 && "Running".equals(result.get(0));
    }

    public void createMachine(String machine) throws Exception {
        logger.debug("Creating Docker machine {} (this can take a few long minutes)...", (Object)machine);
        List<String> result = ProcessRunner.runProcess(this.machineExecutable, "create", "--driver", "virtualbox", machine);
        if (result == null || !this.isMachineCreated(machine)) {
            throw new IllegalStateException("Failed to create a new Docker machine!");
        }
    }

    public void createMachineIfNecessary(String machine) throws Exception {
        if (!this.isMachineCreated(machine)) {
            this.createMachine(machine);
        }
    }

    public void startMachine(String machine) throws Exception {
        logger.debug("Starting Docker machine {}", (Object)machine);
        List<String> result = ProcessRunner.runProcess(this.machineExecutable, "start", machine);
        if (result == null || !this.isMachineRunning(machine)) {
            throw new IllegalStateException("Failed to start Docker machine!");
        }
    }

    public void startDockerMachineIfNecessary(String machine) throws Exception {
        if (!this.isMachineRunning(machine)) {
            this.startMachine(machine);
        }
    }

    public void setupMachineIfNecessary(String machine) throws Exception {
        this.createMachineIfNecessary(machine);
        this.startDockerMachineIfNecessary(machine);
    }

    public DockerClient connect(String machine) throws Exception {
        this.setupMachineIfNecessary(machine);
        List<String> result = ProcessRunner.runProcess(this.machineExecutable, "config", machine);
        if (result != null && result.size() > 0) {
            ConfigParams configParams = result.size() == 1 ? DockerMachineClient.inferConfigParams(Arrays.asList(result.get(0).split(" "))) : DockerMachineClient.inferConfigParams(result);
            DockerClientConfig config = DockerClientConfig.createDefaultConfigBuilder().withDockerTlsVerify(Boolean.valueOf(configParams.isTlsVerify())).withDockerCertPath(configParams.getClientCertificatePath()).withDockerHost(configParams.getHost()).build();
            return new DelegatingDockerClient(DockerClientBuilder.getInstance((DockerClientConfig)config).build(), configParams.getHost());
        }
        return null;
    }

    private static ConfigParams inferConfigParams(List<String> configCommandResult) {
        ConfigParams configParams = new ConfigParams();
        for (String config : configCommandResult) {
            String[] params;
            for (String param : params = config.split(" ")) {
                if ("--tlsverify".equals(param.trim())) {
                    configParams.setTlsVerify(true);
                    continue;
                }
                if (param.startsWith("--tlscert=")) {
                    String clientCertificatePath = param.substring(10);
                    clientCertificatePath = clientCertificatePath.substring(1, clientCertificatePath.length() - 1);
                    int dirSeparator = clientCertificatePath.lastIndexOf(File.separatorChar);
                    configParams.setClientCertificatePath(clientCertificatePath.substring(0, dirSeparator));
                    continue;
                }
                if (!param.startsWith("-H=")) continue;
                configParams.setHost(param.substring(3));
            }
        }
        return configParams;
    }

    private static class ConfigParams {
        private boolean tlsVerify;
        private String clientCertificatePath;
        private String host;

        private ConfigParams() {
        }

        public boolean isTlsVerify() {
            return this.tlsVerify;
        }

        public void setTlsVerify(boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
        }

        public String getClientCertificatePath() {
            return this.clientCertificatePath;
        }

        public void setClientCertificatePath(String clientCertificatePath) {
            this.clientCertificatePath = clientCertificatePath;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }
    }
}

