/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import foundation.stack.docker.Os;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerDownloader {
    private static final Logger logger = LoggerFactory.getLogger(DockerDownloader.class);
    private static final Map<Os, String> osToInstallerExtension = new HashMap<Os, String>(2);
    private static final String DOCKER_USER = "docker";
    private static final String TOOLBOX_REPOSITORY = "toolbox";
    private static final String PKG_EXTENSION = "pkg";
    private static final String EXE_EXTENSION = "exe";
    private static final String DOCKER_INSTALL_SCRIPT_URL = "https://get.docker.com/";

    private static GHAsset getLatestReleaseAsset(Os os) throws IOException {
        GitHub github = GitHub.connectAnonymously();
        GHUser dockerUser = github.getUser(DOCKER_USER);
        if (dockerUser != null) {
            GHRepository toolboxRepository = dockerUser.getRepository(TOOLBOX_REPOSITORY);
            PagedIterable releases = toolboxRepository.listReleases();
            for (GHRelease release : releases) {
                String extension;
                if (release.isDraft() || release.isPrerelease()) continue;
                logger.debug("Downloading latest version of Docker Toolbox - {}", (Object)release.getName());
                List assets = release.getAssets();
                if (assets == null || (extension = osToInstallerExtension.get((Object)os)) == null) continue;
                for (GHAsset asset : assets) {
                    String downloadUrl = asset.getBrowserDownloadUrl();
                    if (downloadUrl == null || !downloadUrl.toLowerCase().endsWith(extension)) continue;
                    logger.debug("Downloading Docker Toolbox from {} ({} MB)", (Object)downloadUrl, (Object)(asset.getSize() / 0x100000L));
                    return asset;
                }
            }
        }
        logger.debug("Could not download installer for operating system {}", (Object)os);
        return null;
    }

    private static File downloadDockerToolbox(BiConsumer<Integer, Integer> progressUpdater, Supplier<Boolean> isCancelled) throws IOException {
        GHAsset asset = DockerDownloader.getLatestReleaseAsset(Os.getSystemOs());
        if (asset != null) {
            String downloadUrl = asset.getBrowserDownloadUrl();
            int totalSize = (int)asset.getSize();
            return DockerDownloader.downloadFileAtUrl(progressUpdater, isCancelled, downloadUrl, totalSize);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static File downloadFileAtUrl(BiConsumer<Integer, Integer> progressUpdater, Supplier<Boolean> isCancelled, String downloadUrl, int totalSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File downloadDocker(BiConsumer<Integer, Integer> progressUpdater, Supplier<Boolean> isCancelled) throws IOException {
        progressUpdater.accept(0, 0);
        if (Os.getSystemOs() == Os.Windows || Os.getSystemOs() == Os.MacOS) {
            return DockerDownloader.downloadDockerToolbox(progressUpdater, isCancelled);
        }
        return DockerDownloader.downloadFileAtUrl(progressUpdater, isCancelled, DOCKER_INSTALL_SCRIPT_URL, -1);
    }

    static {
        osToInstallerExtension.put(Os.MacOS, PKG_EXTENSION);
        osToInstallerExtension.put(Os.Windows, EXE_EXTENSION);
    }
}

