/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import foundation.stack.docker.Os;
import foundation.stack.docker.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kamon.sigar.SigarProvisioner;
import org.hyperic.sigar.win32.RegistryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerDetector {
    private static final Logger logger = LoggerFactory.getLogger(DockerDetector.class);

    public static boolean isDockerInstalled() throws Exception {
        logger.debug("Checking whether Docker is installed");
        switch (Os.getSystemOs()) {
            case Windows: {
                return DockerDetector.isDockerInstalledWindows();
            }
        }
        return DockerDetector.isDockerInstalledUnix();
    }

    private static boolean isDockerInstalledUnix() throws IOException, InterruptedException {
        String result = DockerDetector.getDockerInstallPathForUnix("docker");
        return result != null && !result.isEmpty();
    }

    public static String getDockerInstallPathForUnix(String binary) throws IOException, InterruptedException {
        List<String> result = ProcessRunner.runProcess("which", binary);
        if (result != null && result.size() > 0 && !result.get(0).isEmpty()) {
            logger.debug("Found docker installed at {}", (Object)result.get(0));
            return result.get(0);
        }
        logger.debug("Couldn't find Docker on the PATH");
        return null;
    }

    private static boolean provisionSigar(int alternateLocationAttempt) {
        File attemptLocation = new File(SigarProvisioner.discoverLocation(null), "docker-bootstrap-" + alternateLocationAttempt);
        try {
            SigarProvisioner.provision((File)attemptLocation);
            return true;
        }
        catch (Exception e) {
            if (alternateLocationAttempt < 25) {
                return DockerDetector.provisionSigar(alternateLocationAttempt + 1);
            }
            return false;
        }
    }

    private static void provisionSigarIfNecessary() throws Exception {
        if (!SigarProvisioner.isNativeLoaded()) {
            DockerDetector.provisionSigar(0);
        }
    }

    public static String getDockerInstallPathForWindows() throws Exception {
        DockerDetector.provisionSigarIfNecessary();
        String toolboxPath = null;
        try (RegistryKey environment = null;){
            environment = RegistryKey.CurrentUser.openSubKey("Environment");
            if (environment != null && (toolboxPath = environment.getStringValue("DOCKER_TOOLBOX_INSTALL_PATH")) != null) {
                toolboxPath = toolboxPath.trim();
            }
        }
        return toolboxPath;
    }

    private static boolean isDockerInstalledWindows() throws Exception {
        File toolboxInstallationFile;
        DockerDetector.provisionSigarIfNecessary();
        String toolboxPath = DockerDetector.getDockerInstallPathForWindows();
        if (toolboxPath != null) {
            logger.debug("Found a registered Docker Toolbox installation at {}", (Object)toolboxPath);
        }
        if ((toolboxInstallationFile = new File(toolboxPath)).exists() && toolboxInstallationFile.isDirectory()) {
            logger.debug("Docker Toolbox installation at {} is valid", (Object)toolboxPath);
            return true;
        }
        logger.debug("Docker Toolbox at {} seems to have been uninstalled", (Object)toolboxPath);
        return false;
    }
}

