/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import foundation.stack.docker.DockerDetector;
import foundation.stack.docker.DockerDownloader;
import foundation.stack.docker.DockerInstaller;
import foundation.stack.docker.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapWizard
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapWizard.class);

    public void start(Stage primaryStage) {
        GridPane body = this.createBody();
        this.createAndAddLogo(body);
        this.createAndAddWelcomeText(body);
        this.createAndAddMessageText(body);
        Button continueButton = this.createAndAddContinueButton(body);
        continueButton.setOnAction(event -> this.handleContinue(primaryStage, continueButton, (ActionEvent)event));
        Scene scene = new Scene((Parent)body);
        primaryStage.setScene(scene);
        primaryStage.setTitle(Messages.translate("title"));
        primaryStage.setWidth(680.0);
        primaryStage.setResizable(false);
        primaryStage.show();
        primaryStage.setOnCloseRequest(this::handleClose);
    }

    private void attemptInstall(File downloadedFile, Button continueButton) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(Messages.translate("launchingInstallerTitle"));
        alert.setHeaderText(Messages.translate("launchingInstallerMessage"));
        alert.getButtonTypes().setAll((Object[])new ButtonType[0]);
        alert.setOnCloseRequest(e -> e.consume());
        alert.show();
        int result = -1;
        try {
            result = DockerInstaller.installDocker(downloadedFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        alert.setOnCloseRequest(null);
        alert.setResult((Object)ButtonType.CANCEL);
        alert.close();
        try {
            if (result == 2) {
                logger.debug("Docker install was cancelled");
            } else if (result != 0 || !DockerDetector.isDockerInstalled()) {
                this.handleInstallError();
            }
        }
        catch (Exception e2) {
            logger.debug("Error while trying to determine if Docker installation was successful");
        }
        continueButton.setDisable(false);
    }

    private void attemptDownload(Stage primaryStage, Button continueButton) {
        ProgressDialog progressDialog = new ProgressDialog();
        Task<File> task = new Task<File>(){

            public File call() throws IOException {
                return DockerDownloader.downloadDocker((workDone, totalWork) -> this.updateProgress(workDone.intValue(), totalWork.intValue()), () -> this.isCancelled());
            }
        };
        progressDialog.activateProgressBar(task);
        task.setOnSucceeded(arg_0 -> this.lambda$attemptDownload$4(progressDialog, (Task)task, continueButton, arg_0));
        task.setOnFailed(arg_0 -> this.lambda$attemptDownload$5(progressDialog, continueButton, (Task)task, primaryStage, arg_0));
        progressDialog.getDialogStage().setOnCloseRequest(arg_0 -> this.lambda$attemptDownload$6((Task)task, continueButton, arg_0));
        continueButton.setDisable(true);
        progressDialog.getDialogStage().show();
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }

    private void handleContinue(Stage primaryStage, Button continueButton, ActionEvent _) {
        this.attemptDownload(primaryStage, continueButton);
    }

    private Button createAndAddContinueButton(GridPane body) {
        Button continueButton = new Button(Messages.translate("continue"));
        continueButton.setFont(Font.font((String)Font.getDefault().getName(), (FontWeight)FontWeight.BOLD, (double)18.0));
        HBox buttonContainer = new HBox(10.0);
        buttonContainer.setAlignment(Pos.BOTTOM_RIGHT);
        buttonContainer.getChildren().add((Object)continueButton);
        body.add((Node)buttonContainer, 1, 4);
        return continueButton;
    }

    private GridPane createBody() {
        GridPane grid = new GridPane();
        grid.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        return grid;
    }

    private void createAndAddMessageText(GridPane grid) {
        Text messageText = new Text(Messages.translate("message"));
        messageText.setFont(Font.font((String)Font.getDefault().getName(), (FontWeight)FontWeight.NORMAL, (double)16.0));
        messageText.setWrappingWidth(600.0);
        grid.add((Node)messageText, 0, 2, 2, 1);
    }

    private void createAndAddWelcomeText(GridPane grid) {
        Text welcomeText = new Text(Messages.translate("welcome"));
        welcomeText.setFont(Font.font((String)Font.getDefault().getName(), (FontWeight)FontWeight.BOLD, (double)18.0));
        grid.add((Node)welcomeText, 0, 1, 1, 1);
    }

    private void createAndAddLogo(GridPane grid) {
        Image logo = new Image("logo.png");
        ImageView logoView = new ImageView();
        logoView.setImage(logo);
        logoView.setFitWidth(350.0);
        logoView.setPreserveRatio(true);
        logoView.setSmooth(true);
        logoView.setCache(true);
        grid.add((Node)logoView, 0, 0, 1, 1);
    }

    private void handleDownloadError(Stage primaryStage, Button continueButton) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(Messages.translate("downloadErrorTitle"));
        alert.setHeaderText(Messages.translate("downloadErrorMessage"));
        alert.setContentText(Messages.translate("downloadErrorConfirmation"));
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        Optional result = alert.showAndWait();
        if (result.get() != ButtonType.NO) {
            this.attemptDownload(primaryStage, continueButton);
        }
    }

    private void handleInstallError() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(Messages.translate("installErrorTitle"));
        alert.setHeaderText(Messages.translate("installErrorMessage"));
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        alert.showAndWait();
    }

    private void handleClose(WindowEvent e) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(Messages.translate("cancelTitle"));
        alert.setHeaderText(Messages.translate("cancelMessage"));
        alert.setContentText(Messages.translate("cancelConfirmation"));
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.NO) {
            e.consume();
        }
    }

    public static void launch() {
        BootstrapWizard.launch(BootstrapWizard.class, (String[])new String[0]);
    }

    private /* synthetic */ void lambda$attemptDownload$6(Task task, Button button, WindowEvent request) {
        this.handleClose(request);
        if (!request.isConsumed()) {
            task.cancel();
            button.setDisable(false);
        }
    }

    private /* synthetic */ void lambda$attemptDownload$5(ProgressDialog progressDialog, Button button, Task task, Stage stage, WorkerStateEvent __) {
        progressDialog.getDialogStage().close();
        button.setDisable(false);
        logger.debug("Download failed with exception", task.getException());
        this.handleDownloadError(stage, button);
    }

    private /* synthetic */ void lambda$attemptDownload$4(ProgressDialog progressDialog, Task task, Button button, WorkerStateEvent __) {
        progressDialog.getDialogStage().close();
        logger.debug("Proceeding to install");
        this.attemptInstall((File)task.getValue(), button);
    }

    public class ProgressDialog {
        private final Stage dialogStage;
        private final ProgressBar progressBar = new ProgressBar();
        private final Label progressMessage = new Label();

        public ProgressDialog() {
            this.dialogStage = new Stage();
            this.dialogStage.setTitle(Messages.translate("progressTitle"));
            this.dialogStage.initStyle(StageStyle.UTILITY);
            this.dialogStage.setResizable(false);
            this.dialogStage.initModality(Modality.APPLICATION_MODAL);
            Label message = new Label();
            message.setText(Messages.translate("progressMessage"));
            this.progressBar.setProgress(-1.0);
            this.progressMessage.setText("");
            HBox progressLayout = new HBox();
            progressLayout.setSpacing(10.0);
            progressLayout.getChildren().add((Object)this.progressBar);
            progressLayout.getChildren().add((Object)this.progressMessage);
            HBox.setHgrow((Node)this.progressBar, (Priority)Priority.ALWAYS);
            VBox layout = new VBox();
            layout.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
            layout.setSpacing(10.0);
            layout.getChildren().add((Object)message);
            layout.getChildren().add((Object)progressLayout);
            this.progressBar.prefWidthProperty().bind((ObservableValue)progressLayout.widthProperty().subtract((ObservableNumberValue)this.progressMessage.widthProperty()).subtract(10));
            Scene scene = new Scene((Parent)layout);
            this.dialogStage.setScene(scene);
        }

        public void activateProgressBar(Task<?> task) {
            this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
            this.progressMessage.textProperty().bind((ObservableValue)task.workDoneProperty().divide(0x100000).asString("%.1f").concat((Object)"/").concat((Object)task.totalWorkProperty().divide(0x100000).asString("%.1f")).concat((Object)" MB"));
            this.dialogStage.show();
        }

        public Stage getDialogStage() {
            return this.dialogStage;
        }
    }
}

